/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import javax.imageio.ImageIO;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.BlockStem;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockStateBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionHelper;
import net.minecraft.src.BlockPosM;
import net.minecraft.src.Config;
import net.minecraft.src.ConnectedParser;
import net.minecraft.src.CustomColorFader;
import net.minecraft.src.CustomColormap;
import net.minecraft.src.LightMap;
import net.minecraft.src.LightMapPack;
import net.minecraft.src.MatchBlock;
import net.minecraft.src.Reflector;
import net.minecraft.src.RenderEnv;
import net.minecraft.src.ResUtils;
import net.minecraft.src.StrUtils;
import net.minecraft.src.TextureUtils;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class CustomColors {
    private static String paletteFormatDefault = "vanilla";
    private static CustomColormap waterColors = null;
    private static CustomColormap foliagePineColors = null;
    private static CustomColormap foliageBirchColors = null;
    private static CustomColormap swampFoliageColors = null;
    private static CustomColormap swampGrassColors = null;
    private static CustomColormap[] colorsBlockColormaps = null;
    private static CustomColormap[][] blockColormaps = null;
    private static CustomColormap skyColors = null;
    private static CustomColorFader skyColorFader = new CustomColorFader();
    private static CustomColormap fogColors = null;
    private static CustomColorFader fogColorFader = new CustomColorFader();
    private static CustomColormap underwaterColors = null;
    private static CustomColorFader underwaterColorFader = new CustomColorFader();
    private static CustomColormap underlavaColors = null;
    private static CustomColorFader underlavaColorFader = new CustomColorFader();
    private static LightMapPack[] lightMapPacks = null;
    private static int lightmapMinDimensionId = 0;
    private static CustomColormap redstoneColors = null;
    private static CustomColormap xpOrbColors = null;
    private static int xpOrbTime = -1;
    private static CustomColormap durabilityColors = null;
    private static CustomColormap stemColors = null;
    private static CustomColormap stemMelonColors = null;
    private static CustomColormap stemPumpkinColors = null;
    private static CustomColormap myceliumParticleColors = null;
    private static boolean useDefaultGrassFoliageColors = true;
    private static int particleWaterColor = -1;
    private static int particlePortalColor = -1;
    private static int lilyPadColor = -1;
    private static int expBarTextColor = -1;
    private static int bossTextColor = -1;
    private static int signTextColor = -1;
    private static Vec3 fogColorNether = null;
    private static Vec3 fogColorEnd = null;
    private static Vec3 skyColorEnd = null;
    private static int[] spawnEggPrimaryColors = null;
    private static int[] spawnEggSecondaryColors = null;
    private static float[][] wolfCollarColors = null;
    private static float[][] sheepColors = null;
    private static int[] textColors = null;
    private static int[] mapColorsOriginal = null;
    private static int[] potionColors = null;
    private static final IBlockState BLOCK_STATE_DIRT = Blocks.dirt.getDefaultState();
    private static final IBlockState BLOCK_STATE_WATER = Blocks.water.getDefaultState();
    public static Random random = new Random();
    private static final IColorizer COLORIZER_GRASS = new IColorizer(){

        @Override
        public int getColor(IBlockAccess p_getColor_1_, BlockPos p_getColor_2_) {
            BiomeGenBase biomegenbase = CustomColors.getColorBiome(p_getColor_1_, p_getColor_2_);
            return swampGrassColors != null && biomegenbase == BiomeGenBase.swampland ? swampGrassColors.getColor(biomegenbase, p_getColor_2_) : biomegenbase.getGrassColorAtPos(p_getColor_2_);
        }

        @Override
        public boolean isColorConstant() {
            return false;
        }
    };
    private static final IColorizer COLORIZER_FOLIAGE = new IColorizer(){

        @Override
        public int getColor(IBlockAccess p_getColor_1_, BlockPos p_getColor_2_) {
            BiomeGenBase biomegenbase = CustomColors.getColorBiome(p_getColor_1_, p_getColor_2_);
            return swampFoliageColors != null && biomegenbase == BiomeGenBase.swampland ? swampFoliageColors.getColor(biomegenbase, p_getColor_2_) : biomegenbase.getFoliageColorAtPos(p_getColor_2_);
        }

        @Override
        public boolean isColorConstant() {
            return false;
        }
    };
    private static final IColorizer COLORIZER_FOLIAGE_PINE = new IColorizer(){

        @Override
        public int getColor(IBlockAccess p_getColor_1_, BlockPos p_getColor_2_) {
            return foliagePineColors != null ? foliagePineColors.getColor(p_getColor_1_, p_getColor_2_) : ColorizerFoliage.getFoliageColorPine();
        }

        @Override
        public boolean isColorConstant() {
            return foliagePineColors == null;
        }
    };
    private static final IColorizer COLORIZER_FOLIAGE_BIRCH = new IColorizer(){

        @Override
        public int getColor(IBlockAccess p_getColor_1_, BlockPos p_getColor_2_) {
            return foliageBirchColors != null ? foliageBirchColors.getColor(p_getColor_1_, p_getColor_2_) : ColorizerFoliage.getFoliageColorBirch();
        }

        @Override
        public boolean isColorConstant() {
            return foliageBirchColors == null;
        }
    };
    private static final IColorizer COLORIZER_WATER = new IColorizer(){

        @Override
        public int getColor(IBlockAccess p_getColor_1_, BlockPos p_getColor_2_) {
            BiomeGenBase biomegenbase = CustomColors.getColorBiome(p_getColor_1_, p_getColor_2_);
            return waterColors != null ? waterColors.getColor(biomegenbase, p_getColor_2_) : (Reflector.ForgeBiome_getWaterColorMultiplier.exists() ? Reflector.callInt(biomegenbase, Reflector.ForgeBiome_getWaterColorMultiplier, new Object[0]) : biomegenbase.waterColorMultiplier);
        }

        @Override
        public boolean isColorConstant() {
            return false;
        }
    };

    public static void update() {
        paletteFormatDefault = "vanilla";
        waterColors = null;
        foliageBirchColors = null;
        foliagePineColors = null;
        swampGrassColors = null;
        swampFoliageColors = null;
        skyColors = null;
        fogColors = null;
        underwaterColors = null;
        underlavaColors = null;
        redstoneColors = null;
        xpOrbColors = null;
        xpOrbTime = -1;
        durabilityColors = null;
        stemColors = null;
        myceliumParticleColors = null;
        lightMapPacks = null;
        particleWaterColor = -1;
        particlePortalColor = -1;
        lilyPadColor = -1;
        expBarTextColor = -1;
        bossTextColor = -1;
        signTextColor = -1;
        fogColorNether = null;
        fogColorEnd = null;
        skyColorEnd = null;
        colorsBlockColormaps = null;
        blockColormaps = null;
        useDefaultGrassFoliageColors = true;
        spawnEggPrimaryColors = null;
        spawnEggSecondaryColors = null;
        wolfCollarColors = null;
        sheepColors = null;
        textColors = null;
        CustomColors.setMapColors(mapColorsOriginal);
        potionColors = null;
        PotionHelper.clearPotionColorCache();
        paletteFormatDefault = CustomColors.getValidProperty("mcpatcher/color.properties", "palette.format", CustomColormap.FORMAT_STRINGS, "vanilla");
        String s = "mcpatcher/colormap/";
        String[] astring = new String[]{"water.png", "watercolorX.png"};
        waterColors = CustomColors.getCustomColors(s, astring, 256, 256);
        CustomColors.updateUseDefaultGrassFoliageColors();
        if (Config.isCustomColors()) {
            String[] astring1 = new String[]{"pine.png", "pinecolor.png"};
            foliagePineColors = CustomColors.getCustomColors(s, astring1, 256, 256);
            String[] astring2 = new String[]{"birch.png", "birchcolor.png"};
            foliageBirchColors = CustomColors.getCustomColors(s, astring2, 256, 256);
            String[] astring3 = new String[]{"swampgrass.png", "swampgrasscolor.png"};
            swampGrassColors = CustomColors.getCustomColors(s, astring3, 256, 256);
            String[] astring4 = new String[]{"swampfoliage.png", "swampfoliagecolor.png"};
            swampFoliageColors = CustomColors.getCustomColors(s, astring4, 256, 256);
            String[] astring5 = new String[]{"sky0.png", "skycolor0.png"};
            skyColors = CustomColors.getCustomColors(s, astring5, 256, 256);
            String[] astring6 = new String[]{"fog0.png", "fogcolor0.png"};
            fogColors = CustomColors.getCustomColors(s, astring6, 256, 256);
            String[] astring7 = new String[]{"underwater.png", "underwatercolor.png"};
            underwaterColors = CustomColors.getCustomColors(s, astring7, 256, 256);
            String[] astring8 = new String[]{"underlava.png", "underlavacolor.png"};
            underlavaColors = CustomColors.getCustomColors(s, astring8, 256, 256);
            String[] astring9 = new String[]{"redstone.png", "redstonecolor.png"};
            redstoneColors = CustomColors.getCustomColors(s, astring9, 16, 1);
            xpOrbColors = CustomColors.getCustomColors(String.valueOf(s) + "xporb.png", -1, -1);
            durabilityColors = CustomColors.getCustomColors(String.valueOf(s) + "durability.png", -1, -1);
            String[] astring10 = new String[]{"stem.png", "stemcolor.png"};
            stemColors = CustomColors.getCustomColors(s, astring10, 8, 1);
            stemPumpkinColors = CustomColors.getCustomColors(String.valueOf(s) + "pumpkinstem.png", 8, 1);
            stemMelonColors = CustomColors.getCustomColors(String.valueOf(s) + "melonstem.png", 8, 1);
            String[] astring11 = new String[]{"myceliumparticle.png", "myceliumparticlecolor.png"};
            myceliumParticleColors = CustomColors.getCustomColors(s, astring11, -1, -1);
            Pair<LightMapPack[], Integer> pair = CustomColors.parseLightMapPacks();
            lightMapPacks = (LightMapPack[])pair.getLeft();
            lightmapMinDimensionId = (Integer)pair.getRight();
            CustomColors.readColorProperties("mcpatcher/color.properties");
            blockColormaps = CustomColors.readBlockColormaps(new String[]{String.valueOf(s) + "custom/", String.valueOf(s) + "blocks/"}, colorsBlockColormaps, 256, 256);
            CustomColors.updateUseDefaultGrassFoliageColors();
        }
    }

    private static String getValidProperty(String p_getValidProperty_0_, String p_getValidProperty_1_, String[] p_getValidProperty_2_, String p_getValidProperty_3_) {
        try {
            ResourceLocation resourcelocation = new ResourceLocation(p_getValidProperty_0_);
            InputStream inputstream = Config.getResourceStream(resourcelocation);
            if (inputstream == null) {
                return p_getValidProperty_3_;
            }
            Properties properties = new Properties();
            properties.load(inputstream);
            inputstream.close();
            String s = properties.getProperty(p_getValidProperty_1_);
            if (s == null) {
                return p_getValidProperty_3_;
            }
            List<String> list = Arrays.asList(p_getValidProperty_2_);
            if (!list.contains(s)) {
                CustomColors.warn("Invalid value: " + p_getValidProperty_1_ + "=" + s);
                CustomColors.warn("Expected values: " + Config.arrayToString(p_getValidProperty_2_));
                return p_getValidProperty_3_;
            }
            CustomColors.dbg(p_getValidProperty_1_ + "=" + s);
            return s;
        }
        catch (FileNotFoundException var9) {
            return p_getValidProperty_3_;
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
            return p_getValidProperty_3_;
        }
    }

    private static Pair<LightMapPack[], Integer> parseLightMapPacks() {
        String s = "mcpatcher/lightmap/world";
        String s1 = ".png";
        String[] astring = ResUtils.collectFiles(s, s1);
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        int i = 0;
        while (i < astring.length) {
            String s2 = astring[i];
            String s3 = StrUtils.removePrefixSuffix(s2, s, s1);
            int j = Config.parseInt(s3, Integer.MIN_VALUE);
            if (j == Integer.MIN_VALUE) {
                CustomColors.warn("Invalid dimension ID: " + s3 + ", path: " + s2);
            } else {
                map.put(j, s2);
            }
            ++i;
        }
        Set set = map.keySet();
        Object[] ainteger = set.toArray(new Integer[set.size()]);
        Arrays.sort(ainteger);
        if (ainteger.length <= 0) {
            return new ImmutablePair(null, (Object)0);
        }
        int j1 = (Integer)ainteger[0];
        int k1 = (Integer)ainteger[ainteger.length - 1];
        int k = k1 - j1 + 1;
        CustomColormap[] acustomcolormap = new CustomColormap[k];
        int l = 0;
        while (l < ainteger.length) {
            Object integer = ainteger[l];
            String s4 = (String)map.get(integer);
            CustomColormap customcolormap = CustomColors.getCustomColors(s4, -1, -1);
            if (customcolormap != null) {
                if (customcolormap.getWidth() < 16) {
                    CustomColors.warn("Invalid lightmap width: " + customcolormap.getWidth() + ", path: " + s4);
                } else {
                    int i1 = (Integer)integer - j1;
                    acustomcolormap[i1] = customcolormap;
                }
            }
            ++l;
        }
        LightMapPack[] alightmappack = new LightMapPack[acustomcolormap.length];
        int l1 = 0;
        while (l1 < acustomcolormap.length) {
            CustomColormap customcolormap3 = acustomcolormap[l1];
            if (customcolormap3 != null) {
                LightMapPack lightmappack;
                String s5 = customcolormap3.name;
                String s6 = customcolormap3.basePath;
                CustomColormap customcolormap1 = CustomColors.getCustomColors(String.valueOf(s6) + "/" + s5 + "_rain.png", -1, -1);
                CustomColormap customcolormap2 = CustomColors.getCustomColors(String.valueOf(s6) + "/" + s5 + "_thunder.png", -1, -1);
                LightMap lightmap = new LightMap(customcolormap3);
                LightMap lightmap1 = customcolormap1 != null ? new LightMap(customcolormap1) : null;
                LightMap lightmap2 = customcolormap2 != null ? new LightMap(customcolormap2) : null;
                alightmappack[l1] = lightmappack = new LightMapPack(lightmap, lightmap1, lightmap2);
            }
            ++l1;
        }
        return new ImmutablePair((Object)alightmappack, (Object)j1);
    }

    private static int getTextureHeight(String p_getTextureHeight_0_, int p_getTextureHeight_1_) {
        try {
            InputStream inputstream = Config.getResourceStream(new ResourceLocation(p_getTextureHeight_0_));
            if (inputstream == null) {
                return p_getTextureHeight_1_;
            }
            BufferedImage bufferedimage = ImageIO.read(inputstream);
            inputstream.close();
            return bufferedimage == null ? p_getTextureHeight_1_ : bufferedimage.getHeight();
        }
        catch (IOException var4) {
            return p_getTextureHeight_1_;
        }
    }

    private static void readColorProperties(String p_readColorProperties_0_) {
        try {
            ResourceLocation resourcelocation = new ResourceLocation(p_readColorProperties_0_);
            InputStream inputstream = Config.getResourceStream(resourcelocation);
            if (inputstream == null) {
                return;
            }
            CustomColors.dbg("Loading " + p_readColorProperties_0_);
            Properties properties = new Properties();
            properties.load(inputstream);
            inputstream.close();
            particleWaterColor = CustomColors.readColor(properties, new String[]{"particle.water", "drop.water"});
            particlePortalColor = CustomColors.readColor(properties, "particle.portal");
            lilyPadColor = CustomColors.readColor(properties, "lilypad");
            expBarTextColor = CustomColors.readColor(properties, "text.xpbar");
            bossTextColor = CustomColors.readColor(properties, "text.boss");
            signTextColor = CustomColors.readColor(properties, "text.sign");
            fogColorNether = CustomColors.readColorVec3(properties, "fog.nether");
            fogColorEnd = CustomColors.readColorVec3(properties, "fog.end");
            skyColorEnd = CustomColors.readColorVec3(properties, "sky.end");
            colorsBlockColormaps = CustomColors.readCustomColormaps(properties, p_readColorProperties_0_);
            spawnEggPrimaryColors = CustomColors.readSpawnEggColors(properties, p_readColorProperties_0_, "egg.shell.", "Spawn egg shell");
            spawnEggSecondaryColors = CustomColors.readSpawnEggColors(properties, p_readColorProperties_0_, "egg.spots.", "Spawn egg spot");
            wolfCollarColors = CustomColors.readDyeColors(properties, p_readColorProperties_0_, "collar.", "Wolf collar");
            sheepColors = CustomColors.readDyeColors(properties, p_readColorProperties_0_, "sheep.", "Sheep");
            textColors = CustomColors.readTextColors(properties, p_readColorProperties_0_, "text.code.", "Text");
            int[] aint = CustomColors.readMapColors(properties, p_readColorProperties_0_, "map.", "Map");
            if (aint != null) {
                if (mapColorsOriginal == null) {
                    mapColorsOriginal = CustomColors.getMapColors();
                }
                CustomColors.setMapColors(aint);
            }
            potionColors = CustomColors.readPotionColors(properties, p_readColorProperties_0_, "potion.", "Potion");
            xpOrbTime = Config.parseInt(properties.getProperty("xporb.time"), -1);
        }
        catch (FileNotFoundException var5) {
            return;
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
    }

    private static CustomColormap[] readCustomColormaps(Properties p_readCustomColormaps_0_, String p_readCustomColormaps_1_) {
        ArrayList<CustomColormap> list = new ArrayList<CustomColormap>();
        String s = "palette.block.";
        HashMap<Object, String> map = new HashMap<Object, String>();
        for (Object s1 : p_readCustomColormaps_0_.keySet()) {
            String s2 = p_readCustomColormaps_0_.getProperty((String)s1);
            if (!((String)s1).startsWith(s)) continue;
            map.put(s1, s2);
        }
        String[] astring = map.keySet().toArray(new String[map.size()]);
        int j = 0;
        while (j < astring.length) {
            String s6 = astring[j];
            String s3 = p_readCustomColormaps_0_.getProperty(s6);
            CustomColors.dbg("Block palette: " + s6 + " = " + s3);
            String s4 = s6.substring(s.length());
            String s5 = TextureUtils.getBasePath(p_readCustomColormaps_1_);
            s4 = TextureUtils.fixResourcePath(s4, s5);
            CustomColormap customcolormap = CustomColors.getCustomColors(s4, 256, 256);
            if (customcolormap == null) {
                CustomColors.warn("Colormap not found: " + s4);
            } else {
                ConnectedParser connectedparser = new ConnectedParser("CustomColors");
                MatchBlock[] amatchblock = connectedparser.parseMatchBlocks(s3);
                if (amatchblock != null && amatchblock.length > 0) {
                    int i = 0;
                    while (i < amatchblock.length) {
                        MatchBlock matchblock = amatchblock[i];
                        customcolormap.addMatchBlock(matchblock);
                        ++i;
                    }
                    list.add(customcolormap);
                } else {
                    CustomColors.warn("Invalid match blocks: " + s3);
                }
            }
            ++j;
        }
        if (list.size() <= 0) {
            return null;
        }
        CustomColormap[] acustomcolormap = list.toArray(new CustomColormap[list.size()]);
        return acustomcolormap;
    }

    private static CustomColormap[][] readBlockColormaps(String[] p_readBlockColormaps_0_, CustomColormap[] p_readBlockColormaps_1_, int p_readBlockColormaps_2_, int p_readBlockColormaps_3_) {
        Object[] astring = ResUtils.collectFiles(p_readBlockColormaps_0_, new String[]{".properties"});
        Arrays.sort(astring);
        ArrayList list = new ArrayList();
        int i = 0;
        while (i < astring.length) {
            Object s = astring[i];
            CustomColors.dbg("Block colormap: " + (String)s);
            try {
                ResourceLocation resourcelocation = new ResourceLocation("minecraft", (String)s);
                InputStream inputstream = Config.getResourceStream(resourcelocation);
                if (inputstream == null) {
                    CustomColors.warn("File not found: " + (String)s);
                } else {
                    Properties properties = new Properties();
                    properties.load(inputstream);
                    CustomColormap customcolormap = new CustomColormap(properties, (String)s, p_readBlockColormaps_2_, p_readBlockColormaps_3_, paletteFormatDefault);
                    if (customcolormap.isValid((String)s) && customcolormap.isValidMatchBlocks((String)s)) {
                        CustomColors.addToBlockList(customcolormap, list);
                    }
                }
            }
            catch (FileNotFoundException var12) {
                CustomColors.warn("File not found: " + (String)s);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++i;
        }
        if (p_readBlockColormaps_1_ != null) {
            int j = 0;
            while (j < p_readBlockColormaps_1_.length) {
                CustomColormap customcolormap1 = p_readBlockColormaps_1_[j];
                CustomColors.addToBlockList(customcolormap1, list);
                ++j;
            }
        }
        if (list.size() <= 0) {
            return null;
        }
        CustomColormap[][] acustomcolormap = CustomColors.blockListToArray(list);
        return acustomcolormap;
    }

    private static void addToBlockList(CustomColormap p_addToBlockList_0_, List p_addToBlockList_1_) {
        int[] aint = p_addToBlockList_0_.getMatchBlockIds();
        if (aint != null && aint.length > 0) {
            int i = 0;
            while (i < aint.length) {
                int j = aint[i];
                if (j < 0) {
                    CustomColors.warn("Invalid block ID: " + j);
                } else {
                    CustomColors.addToList(p_addToBlockList_0_, p_addToBlockList_1_, j);
                }
                ++i;
            }
        } else {
            CustomColors.warn("No match blocks: " + Config.arrayToString(aint));
        }
    }

    private static void addToList(CustomColormap p_addToList_0_, List p_addToList_1_, int p_addToList_2_) {
        while (p_addToList_2_ >= p_addToList_1_.size()) {
            p_addToList_1_.add(null);
        }
        ArrayList<CustomColormap> list = (ArrayList<CustomColormap>)p_addToList_1_.get(p_addToList_2_);
        if (list == null) {
            list = new ArrayList<CustomColormap>();
            p_addToList_1_.set(p_addToList_2_, list);
        }
        list.add(p_addToList_0_);
    }

    private static CustomColormap[][] blockListToArray(List p_blockListToArray_0_) {
        CustomColormap[][] acustomcolormap = new CustomColormap[p_blockListToArray_0_.size()][];
        int i = 0;
        while (i < p_blockListToArray_0_.size()) {
            List list = (List)p_blockListToArray_0_.get(i);
            if (list != null) {
                CustomColormap[] acustomcolormap1 = list.toArray(new CustomColormap[list.size()]);
                acustomcolormap[i] = acustomcolormap1;
            }
            ++i;
        }
        return acustomcolormap;
    }

    private static int readColor(Properties p_readColor_0_, String[] p_readColor_1_) {
        int i = 0;
        while (i < p_readColor_1_.length) {
            String s = p_readColor_1_[i];
            int j = CustomColors.readColor(p_readColor_0_, s);
            if (j >= 0) {
                return j;
            }
            ++i;
        }
        return -1;
    }

    private static int readColor(Properties p_readColor_0_, String p_readColor_1_) {
        String s = p_readColor_0_.getProperty(p_readColor_1_);
        if (s == null) {
            return -1;
        }
        int i = CustomColors.parseColor(s = s.trim());
        if (i < 0) {
            CustomColors.warn("Invalid color: " + p_readColor_1_ + " = " + s);
            return i;
        }
        CustomColors.dbg(String.valueOf(p_readColor_1_) + " = " + s);
        return i;
    }

    private static int parseColor(String p_parseColor_0_) {
        if (p_parseColor_0_ == null) {
            return -1;
        }
        p_parseColor_0_ = p_parseColor_0_.trim();
        try {
            int i = Integer.parseInt(p_parseColor_0_, 16) & 0xFFFFFF;
            return i;
        }
        catch (NumberFormatException var2) {
            return -1;
        }
    }

    private static Vec3 readColorVec3(Properties p_readColorVec3_0_, String p_readColorVec3_1_) {
        int i = CustomColors.readColor(p_readColorVec3_0_, p_readColorVec3_1_);
        if (i < 0) {
            return null;
        }
        int j = i >> 16 & 0xFF;
        int k = i >> 8 & 0xFF;
        int l = i & 0xFF;
        float f = (float)j / 255.0f;
        float f1 = (float)k / 255.0f;
        float f2 = (float)l / 255.0f;
        return new Vec3(f, f1, f2);
    }

    private static CustomColormap getCustomColors(String p_getCustomColors_0_, String[] p_getCustomColors_1_, int p_getCustomColors_2_, int p_getCustomColors_3_) {
        int i = 0;
        while (i < p_getCustomColors_1_.length) {
            String s = p_getCustomColors_1_[i];
            s = String.valueOf(p_getCustomColors_0_) + s;
            CustomColormap customcolormap = CustomColors.getCustomColors(s, p_getCustomColors_2_, p_getCustomColors_3_);
            if (customcolormap != null) {
                return customcolormap;
            }
            ++i;
        }
        return null;
    }

    public static CustomColormap getCustomColors(String p_getCustomColors_0_, int p_getCustomColors_1_, int p_getCustomColors_2_) {
        block5: {
            try {
                ResourceLocation resourcelocation = new ResourceLocation(p_getCustomColors_0_);
                if (Config.hasResource(resourcelocation)) break block5;
                return null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
        CustomColors.dbg("Colormap " + p_getCustomColors_0_);
        Properties properties = new Properties();
        String s = StrUtils.replaceSuffix(p_getCustomColors_0_, ".png", ".properties");
        ResourceLocation resourcelocation1 = new ResourceLocation(s);
        if (Config.hasResource(resourcelocation1)) {
            InputStream inputstream = Config.getResourceStream(resourcelocation1);
            properties.load(inputstream);
            inputstream.close();
            CustomColors.dbg("Colormap properties: " + s);
        } else {
            properties.put("format", paletteFormatDefault);
            properties.put("source", p_getCustomColors_0_);
            s = p_getCustomColors_0_;
        }
        CustomColormap customcolormap = new CustomColormap(properties, s, p_getCustomColors_1_, p_getCustomColors_2_, paletteFormatDefault);
        return !customcolormap.isValid(s) ? null : customcolormap;
    }

    public static void updateUseDefaultGrassFoliageColors() {
        useDefaultGrassFoliageColors = foliageBirchColors == null && foliagePineColors == null && swampGrassColors == null && swampFoliageColors == null && Config.isSwampColors() && Config.isSmoothBiomes();
    }

    public static int getColorMultiplier(BakedQuad p_getColorMultiplier_0_, Block p_getColorMultiplier_1_, IBlockAccess p_getColorMultiplier_2_, BlockPos p_getColorMultiplier_3_, RenderEnv p_getColorMultiplier_4_) {
        IColorizer customcolors$icolorizer;
        if (blockColormaps != null) {
            CustomColormap customcolormap;
            IBlockState iblockstate = p_getColorMultiplier_4_.getBlockState();
            if (!p_getColorMultiplier_0_.hasTintIndex()) {
                if (p_getColorMultiplier_1_ == Blocks.grass) {
                    iblockstate = BLOCK_STATE_DIRT;
                }
                if (p_getColorMultiplier_1_ == Blocks.redstone_wire) {
                    return -1;
                }
            }
            if (p_getColorMultiplier_1_ == Blocks.double_plant && p_getColorMultiplier_4_.getMetadata() >= 8) {
                p_getColorMultiplier_3_ = p_getColorMultiplier_3_.down();
                iblockstate = p_getColorMultiplier_2_.getBlockState(p_getColorMultiplier_3_);
            }
            if ((customcolormap = CustomColors.getBlockColormap(iblockstate)) != null) {
                if (Config.isSmoothBiomes() && !customcolormap.isColorConstant()) {
                    return CustomColors.getSmoothColorMultiplier(p_getColorMultiplier_2_, p_getColorMultiplier_3_, customcolormap, p_getColorMultiplier_4_.getColorizerBlockPosM());
                }
                return customcolormap.getColor(p_getColorMultiplier_2_, p_getColorMultiplier_3_);
            }
        }
        if (!p_getColorMultiplier_0_.hasTintIndex()) {
            return -1;
        }
        if (p_getColorMultiplier_1_ == Blocks.waterlily) {
            return CustomColors.getLilypadColorMultiplier(p_getColorMultiplier_2_, p_getColorMultiplier_3_);
        }
        if (p_getColorMultiplier_1_ == Blocks.redstone_wire) {
            return CustomColors.getRedstoneColor(p_getColorMultiplier_4_.getBlockState());
        }
        if (p_getColorMultiplier_1_ instanceof BlockStem) {
            return CustomColors.getStemColorMultiplier(p_getColorMultiplier_1_, p_getColorMultiplier_2_, p_getColorMultiplier_3_, p_getColorMultiplier_4_);
        }
        if (useDefaultGrassFoliageColors) {
            return -1;
        }
        int i = p_getColorMultiplier_4_.getMetadata();
        if (p_getColorMultiplier_1_ != Blocks.grass && p_getColorMultiplier_1_ != Blocks.tallgrass && p_getColorMultiplier_1_ != Blocks.double_plant) {
            if (p_getColorMultiplier_1_ == Blocks.double_plant) {
                customcolors$icolorizer = COLORIZER_GRASS;
                if (i >= 8) {
                    p_getColorMultiplier_3_ = p_getColorMultiplier_3_.down();
                }
            } else if (p_getColorMultiplier_1_ == Blocks.leaves) {
                switch (i & 3) {
                    case 0: {
                        customcolors$icolorizer = COLORIZER_FOLIAGE;
                        break;
                    }
                    case 1: {
                        customcolors$icolorizer = COLORIZER_FOLIAGE_PINE;
                        break;
                    }
                    case 2: {
                        customcolors$icolorizer = COLORIZER_FOLIAGE_BIRCH;
                        break;
                    }
                    default: {
                        customcolors$icolorizer = COLORIZER_FOLIAGE;
                        break;
                    }
                }
            } else if (p_getColorMultiplier_1_ == Blocks.leaves2) {
                customcolors$icolorizer = COLORIZER_FOLIAGE;
            } else {
                if (p_getColorMultiplier_1_ != Blocks.vine) {
                    return -1;
                }
                customcolors$icolorizer = COLORIZER_FOLIAGE;
            }
        } else {
            customcolors$icolorizer = COLORIZER_GRASS;
        }
        return Config.isSmoothBiomes() && !customcolors$icolorizer.isColorConstant() ? CustomColors.getSmoothColorMultiplier(p_getColorMultiplier_2_, p_getColorMultiplier_3_, customcolors$icolorizer, p_getColorMultiplier_4_.getColorizerBlockPosM()) : customcolors$icolorizer.getColor(p_getColorMultiplier_2_, p_getColorMultiplier_3_);
    }

    protected static BiomeGenBase getColorBiome(IBlockAccess p_getColorBiome_0_, BlockPos p_getColorBiome_1_) {
        BiomeGenBase biomegenbase = p_getColorBiome_0_.getBiomeGenForCoords(p_getColorBiome_1_);
        if (biomegenbase == BiomeGenBase.swampland && !Config.isSwampColors()) {
            biomegenbase = BiomeGenBase.plains;
        }
        return biomegenbase;
    }

    private static CustomColormap getBlockColormap(IBlockState p_getBlockColormap_0_) {
        if (blockColormaps == null) {
            return null;
        }
        if (!(p_getBlockColormap_0_ instanceof BlockStateBase)) {
            return null;
        }
        BlockStateBase blockstatebase = (BlockStateBase)p_getBlockColormap_0_;
        int i = blockstatebase.getBlockId();
        if (i >= 0 && i < blockColormaps.length) {
            CustomColormap[] acustomcolormap = blockColormaps[i];
            if (acustomcolormap == null) {
                return null;
            }
            int j = 0;
            while (j < acustomcolormap.length) {
                CustomColormap customcolormap = acustomcolormap[j];
                if (customcolormap.matchesBlock(blockstatebase)) {
                    return customcolormap;
                }
                ++j;
            }
            return null;
        }
        return null;
    }

    private static int getSmoothColorMultiplier(IBlockAccess p_getSmoothColorMultiplier_0_, BlockPos p_getSmoothColorMultiplier_1_, IColorizer p_getSmoothColorMultiplier_2_, BlockPosM p_getSmoothColorMultiplier_3_) {
        int i = 0;
        int j = 0;
        int k = 0;
        int l = p_getSmoothColorMultiplier_1_.getX();
        int i1 = p_getSmoothColorMultiplier_1_.getY();
        int j1 = p_getSmoothColorMultiplier_1_.getZ();
        BlockPosM blockposm = p_getSmoothColorMultiplier_3_;
        int k1 = l - 1;
        while (k1 <= l + 1) {
            int l1 = j1 - 1;
            while (l1 <= j1 + 1) {
                blockposm.setXyz(k1, i1, l1);
                int i2 = p_getSmoothColorMultiplier_2_.getColor(p_getSmoothColorMultiplier_0_, blockposm);
                i += i2 >> 16 & 0xFF;
                j += i2 >> 8 & 0xFF;
                k += i2 & 0xFF;
                ++l1;
            }
            ++k1;
        }
        int j2 = i / 9;
        int k2 = j / 9;
        int l2 = k / 9;
        return j2 << 16 | k2 << 8 | l2;
    }

    public static int getFluidColor(IBlockAccess p_getFluidColor_0_, IBlockState p_getFluidColor_1_, BlockPos p_getFluidColor_2_, RenderEnv p_getFluidColor_3_) {
        Block block = p_getFluidColor_1_.getBlock();
        IColorizer customcolors$icolorizer = CustomColors.getBlockColormap(p_getFluidColor_1_);
        if (customcolors$icolorizer == null && block.getMaterial() == Material.water) {
            customcolors$icolorizer = COLORIZER_WATER;
        }
        return customcolors$icolorizer == null ? block.colorMultiplier(p_getFluidColor_0_, p_getFluidColor_2_) : (Config.isSmoothBiomes() && !customcolors$icolorizer.isColorConstant() ? CustomColors.getSmoothColorMultiplier(p_getFluidColor_0_, p_getFluidColor_2_, customcolors$icolorizer, p_getFluidColor_3_.getColorizerBlockPosM()) : customcolors$icolorizer.getColor(p_getFluidColor_0_, p_getFluidColor_2_));
    }

    public static void updatePortalFX(EntityFX p_updatePortalFX_0_) {
        if (particlePortalColor >= 0) {
            int i = particlePortalColor;
            int j = i >> 16 & 0xFF;
            int k = i >> 8 & 0xFF;
            int l = i & 0xFF;
            float f = (float)j / 255.0f;
            float f1 = (float)k / 255.0f;
            float f2 = (float)l / 255.0f;
            p_updatePortalFX_0_.setRBGColorF(f, f1, f2);
        }
    }

    public static void updateMyceliumFX(EntityFX p_updateMyceliumFX_0_) {
        if (myceliumParticleColors != null) {
            int i = myceliumParticleColors.getColorRandom();
            int j = i >> 16 & 0xFF;
            int k = i >> 8 & 0xFF;
            int l = i & 0xFF;
            float f = (float)j / 255.0f;
            float f1 = (float)k / 255.0f;
            float f2 = (float)l / 255.0f;
            p_updateMyceliumFX_0_.setRBGColorF(f, f1, f2);
        }
    }

    private static int getRedstoneColor(IBlockState p_getRedstoneColor_0_) {
        if (redstoneColors == null) {
            return -1;
        }
        int i = CustomColors.getRedstoneLevel(p_getRedstoneColor_0_, 15);
        int j = redstoneColors.getColor(i);
        return j;
    }

    public static void updateReddustFX(EntityFX p_updateReddustFX_0_, IBlockAccess p_updateReddustFX_1_, double p_updateReddustFX_2_, double p_updateReddustFX_4_, double p_updateReddustFX_6_) {
        if (redstoneColors != null) {
            IBlockState iblockstate = p_updateReddustFX_1_.getBlockState(new BlockPos(p_updateReddustFX_2_, p_updateReddustFX_4_, p_updateReddustFX_6_));
            int i = CustomColors.getRedstoneLevel(iblockstate, 15);
            int j = redstoneColors.getColor(i);
            int k = j >> 16 & 0xFF;
            int l = j >> 8 & 0xFF;
            int i1 = j & 0xFF;
            float f = (float)k / 255.0f;
            float f1 = (float)l / 255.0f;
            float f2 = (float)i1 / 255.0f;
            p_updateReddustFX_0_.setRBGColorF(f, f1, f2);
        }
    }

    private static int getRedstoneLevel(IBlockState p_getRedstoneLevel_0_, int p_getRedstoneLevel_1_) {
        Block block = p_getRedstoneLevel_0_.getBlock();
        if (!(block instanceof BlockRedstoneWire)) {
            return p_getRedstoneLevel_1_;
        }
        Integer object = p_getRedstoneLevel_0_.getValue(BlockRedstoneWire.POWER);
        if (!(object instanceof Integer)) {
            return p_getRedstoneLevel_1_;
        }
        Integer integer = object;
        return integer;
    }

    public static float getXpOrbTimer(float p_getXpOrbTimer_0_) {
        if (xpOrbTime <= 0) {
            return p_getXpOrbTimer_0_;
        }
        float f = 628.0f / (float)xpOrbTime;
        return p_getXpOrbTimer_0_ * f;
    }

    public static int getXpOrbColor(float p_getXpOrbColor_0_) {
        if (xpOrbColors == null) {
            return -1;
        }
        int i = (int)Math.round((double)((MathHelper.sin(p_getXpOrbColor_0_) + 1.0f) * (float)(xpOrbColors.getLength() - 1)) / 2.0);
        int j = xpOrbColors.getColor(i);
        return j;
    }

    public static int getDurabilityColor(int p_getDurabilityColor_0_) {
        if (durabilityColors == null) {
            return -1;
        }
        int i = p_getDurabilityColor_0_ * durabilityColors.getLength() / 255;
        int j = durabilityColors.getColor(i);
        return j;
    }

    public static void updateWaterFX(EntityFX p_updateWaterFX_0_, IBlockAccess p_updateWaterFX_1_, double p_updateWaterFX_2_, double p_updateWaterFX_4_, double p_updateWaterFX_6_) {
        if (waterColors != null || blockColormaps != null) {
            BlockPos blockpos = new BlockPos(p_updateWaterFX_2_, p_updateWaterFX_4_, p_updateWaterFX_6_);
            RenderEnv renderenv = RenderEnv.getInstance(p_updateWaterFX_1_, BLOCK_STATE_WATER, blockpos);
            int i = CustomColors.getFluidColor(p_updateWaterFX_1_, BLOCK_STATE_WATER, blockpos, renderenv);
            int j = i >> 16 & 0xFF;
            int k = i >> 8 & 0xFF;
            int l = i & 0xFF;
            float f = (float)j / 255.0f;
            float f1 = (float)k / 255.0f;
            float f2 = (float)l / 255.0f;
            if (particleWaterColor >= 0) {
                int i1 = particleWaterColor >> 16 & 0xFF;
                int j1 = particleWaterColor >> 8 & 0xFF;
                int k1 = particleWaterColor & 0xFF;
                f *= (float)i1 / 255.0f;
                f1 *= (float)j1 / 255.0f;
                f2 *= (float)k1 / 255.0f;
            }
            p_updateWaterFX_0_.setRBGColorF(f, f1, f2);
        }
    }

    private static int getLilypadColorMultiplier(IBlockAccess p_getLilypadColorMultiplier_0_, BlockPos p_getLilypadColorMultiplier_1_) {
        return lilyPadColor < 0 ? Blocks.waterlily.colorMultiplier(p_getLilypadColorMultiplier_0_, p_getLilypadColorMultiplier_1_) : lilyPadColor;
    }

    private static Vec3 getFogColorNether(Vec3 p_getFogColorNether_0_) {
        return fogColorNether == null ? p_getFogColorNether_0_ : fogColorNether;
    }

    private static Vec3 getFogColorEnd(Vec3 p_getFogColorEnd_0_) {
        return fogColorEnd == null ? p_getFogColorEnd_0_ : fogColorEnd;
    }

    private static Vec3 getSkyColorEnd(Vec3 p_getSkyColorEnd_0_) {
        return skyColorEnd == null ? p_getSkyColorEnd_0_ : skyColorEnd;
    }

    public static Vec3 getSkyColor(Vec3 p_getSkyColor_0_, IBlockAccess p_getSkyColor_1_, double p_getSkyColor_2_, double p_getSkyColor_4_, double p_getSkyColor_6_) {
        if (skyColors == null) {
            return p_getSkyColor_0_;
        }
        int i = skyColors.getColorSmooth(p_getSkyColor_1_, p_getSkyColor_2_, p_getSkyColor_4_, p_getSkyColor_6_, 3);
        int j = i >> 16 & 0xFF;
        int k = i >> 8 & 0xFF;
        int l = i & 0xFF;
        float f = (float)j / 255.0f;
        float f1 = (float)k / 255.0f;
        float f2 = (float)l / 255.0f;
        float f3 = (float)p_getSkyColor_0_.xCoord / 0.5f;
        float f4 = (float)p_getSkyColor_0_.yCoord / 0.66275f;
        float f5 = (float)p_getSkyColor_0_.zCoord;
        Vec3 vec3 = skyColorFader.getColor(f *= f3, f1 *= f4, f2 *= f5);
        return vec3;
    }

    private static Vec3 getFogColor(Vec3 p_getFogColor_0_, IBlockAccess p_getFogColor_1_, double p_getFogColor_2_, double p_getFogColor_4_, double p_getFogColor_6_) {
        if (fogColors == null) {
            return p_getFogColor_0_;
        }
        int i = fogColors.getColorSmooth(p_getFogColor_1_, p_getFogColor_2_, p_getFogColor_4_, p_getFogColor_6_, 3);
        int j = i >> 16 & 0xFF;
        int k = i >> 8 & 0xFF;
        int l = i & 0xFF;
        float f = (float)j / 255.0f;
        float f1 = (float)k / 255.0f;
        float f2 = (float)l / 255.0f;
        float f3 = (float)p_getFogColor_0_.xCoord / 0.753f;
        float f4 = (float)p_getFogColor_0_.yCoord / 0.8471f;
        float f5 = (float)p_getFogColor_0_.zCoord;
        Vec3 vec3 = fogColorFader.getColor(f *= f3, f1 *= f4, f2 *= f5);
        return vec3;
    }

    public static Vec3 getUnderwaterColor(IBlockAccess p_getUnderwaterColor_0_, double p_getUnderwaterColor_1_, double p_getUnderwaterColor_3_, double p_getUnderwaterColor_5_) {
        return CustomColors.getUnderFluidColor(p_getUnderwaterColor_0_, p_getUnderwaterColor_1_, p_getUnderwaterColor_3_, p_getUnderwaterColor_5_, underwaterColors, underwaterColorFader);
    }

    public static Vec3 getUnderlavaColor(IBlockAccess p_getUnderlavaColor_0_, double p_getUnderlavaColor_1_, double p_getUnderlavaColor_3_, double p_getUnderlavaColor_5_) {
        return CustomColors.getUnderFluidColor(p_getUnderlavaColor_0_, p_getUnderlavaColor_1_, p_getUnderlavaColor_3_, p_getUnderlavaColor_5_, underlavaColors, underlavaColorFader);
    }

    public static Vec3 getUnderFluidColor(IBlockAccess p_getUnderFluidColor_0_, double p_getUnderFluidColor_1_, double p_getUnderFluidColor_3_, double p_getUnderFluidColor_5_, CustomColormap p_getUnderFluidColor_7_, CustomColorFader p_getUnderFluidColor_8_) {
        if (p_getUnderFluidColor_7_ == null) {
            return null;
        }
        int i = p_getUnderFluidColor_7_.getColorSmooth(p_getUnderFluidColor_0_, p_getUnderFluidColor_1_, p_getUnderFluidColor_3_, p_getUnderFluidColor_5_, 3);
        int j = i >> 16 & 0xFF;
        int k = i >> 8 & 0xFF;
        int l = i & 0xFF;
        float f = (float)j / 255.0f;
        float f1 = (float)k / 255.0f;
        float f2 = (float)l / 255.0f;
        Vec3 vec3 = p_getUnderFluidColor_8_.getColor(f, f1, f2);
        return vec3;
    }

    private static int getStemColorMultiplier(Block p_getStemColorMultiplier_0_, IBlockAccess p_getStemColorMultiplier_1_, BlockPos p_getStemColorMultiplier_2_, RenderEnv p_getStemColorMultiplier_3_) {
        CustomColormap customcolormap = stemColors;
        if (p_getStemColorMultiplier_0_ == Blocks.pumpkin_stem && stemPumpkinColors != null) {
            customcolormap = stemPumpkinColors;
        }
        if (p_getStemColorMultiplier_0_ == Blocks.melon_stem && stemMelonColors != null) {
            customcolormap = stemMelonColors;
        }
        if (customcolormap == null) {
            return -1;
        }
        int i = p_getStemColorMultiplier_3_.getMetadata();
        return customcolormap.getColor(i);
    }

    public static boolean updateLightmap(World p_updateLightmap_0_, float p_updateLightmap_1_, int[] p_updateLightmap_2_, boolean p_updateLightmap_3_, float p_updateLightmap_4_) {
        if (p_updateLightmap_0_ == null) {
            return false;
        }
        if (lightMapPacks == null) {
            return false;
        }
        int i = p_updateLightmap_0_.provider.getDimensionId();
        int j = i - lightmapMinDimensionId;
        if (j >= 0 && j < lightMapPacks.length) {
            LightMapPack lightmappack = lightMapPacks[j];
            return lightmappack == null ? false : lightmappack.updateLightmap(p_updateLightmap_0_, p_updateLightmap_1_, p_updateLightmap_2_, p_updateLightmap_3_, p_updateLightmap_4_);
        }
        return false;
    }

    public static Vec3 getWorldFogColor(Vec3 p_getWorldFogColor_0_, WorldClient p_getWorldFogColor_1_, Entity p_getWorldFogColor_2_, float p_getWorldFogColor_3_) {
        int i = p_getWorldFogColor_1_.provider.getDimensionId();
        switch (i) {
            case -1: {
                p_getWorldFogColor_0_ = CustomColors.getFogColorNether(p_getWorldFogColor_0_);
                break;
            }
            case 0: {
                Minecraft minecraft = Minecraft.getMinecraft();
                p_getWorldFogColor_0_ = CustomColors.getFogColor(p_getWorldFogColor_0_, minecraft.theWorld, p_getWorldFogColor_2_.posX, p_getWorldFogColor_2_.posY + 1.0, p_getWorldFogColor_2_.posZ);
                break;
            }
            case 1: {
                p_getWorldFogColor_0_ = CustomColors.getFogColorEnd(p_getWorldFogColor_0_);
            }
        }
        return p_getWorldFogColor_0_;
    }

    public static Vec3 getWorldSkyColor(Vec3 p_getWorldSkyColor_0_, World p_getWorldSkyColor_1_, Entity p_getWorldSkyColor_2_, float p_getWorldSkyColor_3_) {
        int i = p_getWorldSkyColor_1_.provider.getDimensionId();
        switch (i) {
            case 0: {
                Minecraft minecraft = Minecraft.getMinecraft();
                p_getWorldSkyColor_0_ = CustomColors.getSkyColor(p_getWorldSkyColor_0_, minecraft.theWorld, p_getWorldSkyColor_2_.posX, p_getWorldSkyColor_2_.posY + 1.0, p_getWorldSkyColor_2_.posZ);
                break;
            }
            case 1: {
                p_getWorldSkyColor_0_ = CustomColors.getSkyColorEnd(p_getWorldSkyColor_0_);
            }
        }
        return p_getWorldSkyColor_0_;
    }

    private static int[] readSpawnEggColors(Properties p_readSpawnEggColors_0_, String p_readSpawnEggColors_1_, String p_readSpawnEggColors_2_, String p_readSpawnEggColors_3_) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        Set<Object> set = p_readSpawnEggColors_0_.keySet();
        int i = 0;
        for (Object s : set) {
            String s1 = p_readSpawnEggColors_0_.getProperty((String)s);
            if (!((String)s).startsWith(p_readSpawnEggColors_2_)) continue;
            String s2 = StrUtils.removePrefix((String)s, p_readSpawnEggColors_2_);
            int j = CustomColors.getEntityId(s2);
            int k = CustomColors.parseColor(s1);
            if (j >= 0 && k >= 0) {
                while (list.size() <= j) {
                    list.add(-1);
                }
                list.set(j, k);
                ++i;
                continue;
            }
            CustomColors.warn("Invalid spawn egg color: " + s + " = " + s1);
        }
        if (i <= 0) {
            return null;
        }
        CustomColors.dbg(String.valueOf(p_readSpawnEggColors_3_) + " colors: " + i);
        int[] aint = new int[list.size()];
        int l = 0;
        while (l < aint.length) {
            aint[l] = (Integer)list.get(l);
            ++l;
        }
        return aint;
    }

    private static int getSpawnEggColor(ItemMonsterPlacer p_getSpawnEggColor_0_, ItemStack p_getSpawnEggColor_1_, int p_getSpawnEggColor_2_, int p_getSpawnEggColor_3_) {
        int[] aint;
        int i = p_getSpawnEggColor_1_.getMetadata();
        int[] nArray = aint = p_getSpawnEggColor_2_ == 0 ? spawnEggPrimaryColors : spawnEggSecondaryColors;
        if (aint == null) {
            return p_getSpawnEggColor_3_;
        }
        if (i >= 0 && i < aint.length) {
            int j = aint[i];
            return j < 0 ? p_getSpawnEggColor_3_ : j;
        }
        return p_getSpawnEggColor_3_;
    }

    public static int getColorFromItemStack(ItemStack p_getColorFromItemStack_0_, int p_getColorFromItemStack_1_, int p_getColorFromItemStack_2_) {
        if (p_getColorFromItemStack_0_ == null) {
            return p_getColorFromItemStack_2_;
        }
        Item item = p_getColorFromItemStack_0_.getItem();
        return item == null ? p_getColorFromItemStack_2_ : (item instanceof ItemMonsterPlacer ? CustomColors.getSpawnEggColor((ItemMonsterPlacer)item, p_getColorFromItemStack_0_, p_getColorFromItemStack_1_, p_getColorFromItemStack_2_) : p_getColorFromItemStack_2_);
    }

    private static float[][] readDyeColors(Properties p_readDyeColors_0_, String p_readDyeColors_1_, String p_readDyeColors_2_, String p_readDyeColors_3_) {
        EnumDyeColor[] aenumdyecolor = EnumDyeColor.values();
        HashMap<String, EnumDyeColor> map = new HashMap<String, EnumDyeColor>();
        int i = 0;
        while (i < aenumdyecolor.length) {
            EnumDyeColor enumdyecolor = aenumdyecolor[i];
            map.put(enumdyecolor.getName(), enumdyecolor);
            ++i;
        }
        float[][] afloat1 = new float[aenumdyecolor.length][];
        int k = 0;
        for (Object s : p_readDyeColors_0_.keySet()) {
            String s1 = p_readDyeColors_0_.getProperty((String)s);
            if (!((String)s).startsWith(p_readDyeColors_2_)) continue;
            String s2 = StrUtils.removePrefix((String)s, p_readDyeColors_2_);
            if (s2.equals("lightBlue")) {
                s2 = "light_blue";
            }
            EnumDyeColor enumdyecolor1 = (EnumDyeColor)map.get(s2);
            int j = CustomColors.parseColor(s1);
            if (enumdyecolor1 != null && j >= 0) {
                float[] afloat = new float[]{(float)(j >> 16 & 0xFF) / 255.0f, (float)(j >> 8 & 0xFF) / 255.0f, (float)(j & 0xFF) / 255.0f};
                afloat1[enumdyecolor1.ordinal()] = afloat;
                ++k;
                continue;
            }
            CustomColors.warn("Invalid color: " + s + " = " + s1);
        }
        if (k <= 0) {
            return null;
        }
        CustomColors.dbg(String.valueOf(p_readDyeColors_3_) + " colors: " + k);
        return afloat1;
    }

    private static float[] getDyeColors(EnumDyeColor p_getDyeColors_0_, float[][] p_getDyeColors_1_, float[] p_getDyeColors_2_) {
        if (p_getDyeColors_1_ == null) {
            return p_getDyeColors_2_;
        }
        if (p_getDyeColors_0_ == null) {
            return p_getDyeColors_2_;
        }
        float[] afloat = p_getDyeColors_1_[p_getDyeColors_0_.ordinal()];
        return afloat == null ? p_getDyeColors_2_ : afloat;
    }

    public static float[] getWolfCollarColors(EnumDyeColor p_getWolfCollarColors_0_, float[] p_getWolfCollarColors_1_) {
        return CustomColors.getDyeColors(p_getWolfCollarColors_0_, wolfCollarColors, p_getWolfCollarColors_1_);
    }

    public static float[] getSheepColors(EnumDyeColor p_getSheepColors_0_, float[] p_getSheepColors_1_) {
        return CustomColors.getDyeColors(p_getSheepColors_0_, sheepColors, p_getSheepColors_1_);
    }

    private static int[] readTextColors(Properties p_readTextColors_0_, String p_readTextColors_1_, String p_readTextColors_2_, String p_readTextColors_3_) {
        int[] aint = new int[32];
        Arrays.fill(aint, -1);
        int i = 0;
        for (Object s : p_readTextColors_0_.keySet()) {
            String s1 = p_readTextColors_0_.getProperty((String)s);
            if (!((String)s).startsWith(p_readTextColors_2_)) continue;
            String s2 = StrUtils.removePrefix((String)s, p_readTextColors_2_);
            int j = Config.parseInt(s2, -1);
            int k = CustomColors.parseColor(s1);
            if (j >= 0 && j < aint.length && k >= 0) {
                aint[j] = k;
                ++i;
                continue;
            }
            CustomColors.warn("Invalid color: " + s + " = " + s1);
        }
        if (i <= 0) {
            return null;
        }
        CustomColors.dbg(String.valueOf(p_readTextColors_3_) + " colors: " + i);
        return aint;
    }

    public static int getTextColor(int p_getTextColor_0_, int p_getTextColor_1_) {
        if (textColors == null) {
            return p_getTextColor_1_;
        }
        if (p_getTextColor_0_ >= 0 && p_getTextColor_0_ < textColors.length) {
            int i = textColors[p_getTextColor_0_];
            return i < 0 ? p_getTextColor_1_ : i;
        }
        return p_getTextColor_1_;
    }

    private static int[] readMapColors(Properties p_readMapColors_0_, String p_readMapColors_1_, String p_readMapColors_2_, String p_readMapColors_3_) {
        int[] aint = new int[MapColor.mapColorArray.length];
        Arrays.fill(aint, -1);
        int i = 0;
        for (Object s : p_readMapColors_0_.keySet()) {
            String s1 = p_readMapColors_0_.getProperty((String)s);
            if (!((String)s).startsWith(p_readMapColors_2_)) continue;
            String s2 = StrUtils.removePrefix((String)s, p_readMapColors_2_);
            int j = CustomColors.getMapColorIndex(s2);
            int k = CustomColors.parseColor(s1);
            if (j >= 0 && j < aint.length && k >= 0) {
                aint[j] = k;
                ++i;
                continue;
            }
            CustomColors.warn("Invalid color: " + s + " = " + s1);
        }
        if (i <= 0) {
            return null;
        }
        CustomColors.dbg(String.valueOf(p_readMapColors_3_) + " colors: " + i);
        return aint;
    }

    private static int[] readPotionColors(Properties p_readPotionColors_0_, String p_readPotionColors_1_, String p_readPotionColors_2_, String p_readPotionColors_3_) {
        int[] aint = new int[Potion.potionTypes.length];
        Arrays.fill(aint, -1);
        int i = 0;
        for (Object s : p_readPotionColors_0_.keySet()) {
            String s1 = p_readPotionColors_0_.getProperty((String)s);
            if (!((String)s).startsWith(p_readPotionColors_2_)) continue;
            int j = CustomColors.getPotionId((String)s);
            int k = CustomColors.parseColor(s1);
            if (j >= 0 && j < aint.length && k >= 0) {
                aint[j] = k;
                ++i;
                continue;
            }
            CustomColors.warn("Invalid color: " + s + " = " + s1);
        }
        if (i <= 0) {
            return null;
        }
        CustomColors.dbg(String.valueOf(p_readPotionColors_3_) + " colors: " + i);
        return aint;
    }

    private static int getPotionId(String p_getPotionId_0_) {
        if (p_getPotionId_0_.equals("potion.water")) {
            return 0;
        }
        Potion[] apotion = Potion.potionTypes;
        int i = 0;
        while (i < apotion.length) {
            Potion potion = apotion[i];
            if (potion != null && potion.getName().equals(p_getPotionId_0_)) {
                return potion.getId();
            }
            ++i;
        }
        return -1;
    }

    public static int getPotionColor(int p_getPotionColor_0_, int p_getPotionColor_1_) {
        if (potionColors == null) {
            return p_getPotionColor_1_;
        }
        if (p_getPotionColor_0_ >= 0 && p_getPotionColor_0_ < potionColors.length) {
            int i = potionColors[p_getPotionColor_0_];
            return i < 0 ? p_getPotionColor_1_ : i;
        }
        return p_getPotionColor_1_;
    }

    private static int getMapColorIndex(String p_getMapColorIndex_0_) {
        return p_getMapColorIndex_0_ == null ? -1 : (p_getMapColorIndex_0_.equals("air") ? MapColor.airColor.colorIndex : (p_getMapColorIndex_0_.equals("grass") ? MapColor.grassColor.colorIndex : (p_getMapColorIndex_0_.equals("sand") ? MapColor.sandColor.colorIndex : (p_getMapColorIndex_0_.equals("cloth") ? MapColor.clothColor.colorIndex : (p_getMapColorIndex_0_.equals("tnt") ? MapColor.tntColor.colorIndex : (p_getMapColorIndex_0_.equals("ice") ? MapColor.iceColor.colorIndex : (p_getMapColorIndex_0_.equals("iron") ? MapColor.ironColor.colorIndex : (p_getMapColorIndex_0_.equals("foliage") ? MapColor.foliageColor.colorIndex : (p_getMapColorIndex_0_.equals("clay") ? MapColor.clayColor.colorIndex : (p_getMapColorIndex_0_.equals("dirt") ? MapColor.dirtColor.colorIndex : (p_getMapColorIndex_0_.equals("stone") ? MapColor.stoneColor.colorIndex : (p_getMapColorIndex_0_.equals("water") ? MapColor.waterColor.colorIndex : (p_getMapColorIndex_0_.equals("wood") ? MapColor.woodColor.colorIndex : (p_getMapColorIndex_0_.equals("quartz") ? MapColor.quartzColor.colorIndex : (p_getMapColorIndex_0_.equals("gold") ? MapColor.goldColor.colorIndex : (p_getMapColorIndex_0_.equals("diamond") ? MapColor.diamondColor.colorIndex : (p_getMapColorIndex_0_.equals("lapis") ? MapColor.lapisColor.colorIndex : (p_getMapColorIndex_0_.equals("emerald") ? MapColor.emeraldColor.colorIndex : (p_getMapColorIndex_0_.equals("podzol") ? MapColor.obsidianColor.colorIndex : (p_getMapColorIndex_0_.equals("netherrack") ? MapColor.netherrackColor.colorIndex : (!p_getMapColorIndex_0_.equals("snow") && !p_getMapColorIndex_0_.equals("white") ? (!p_getMapColorIndex_0_.equals("adobe") && !p_getMapColorIndex_0_.equals("orange") ? (p_getMapColorIndex_0_.equals("magenta") ? MapColor.magentaColor.colorIndex : (!p_getMapColorIndex_0_.equals("light_blue") && !p_getMapColorIndex_0_.equals("lightBlue") ? (p_getMapColorIndex_0_.equals("yellow") ? MapColor.yellowColor.colorIndex : (p_getMapColorIndex_0_.equals("lime") ? MapColor.limeColor.colorIndex : (p_getMapColorIndex_0_.equals("pink") ? MapColor.pinkColor.colorIndex : (p_getMapColorIndex_0_.equals("gray") ? MapColor.grayColor.colorIndex : (p_getMapColorIndex_0_.equals("silver") ? MapColor.silverColor.colorIndex : (p_getMapColorIndex_0_.equals("cyan") ? MapColor.cyanColor.colorIndex : (p_getMapColorIndex_0_.equals("purple") ? MapColor.purpleColor.colorIndex : (p_getMapColorIndex_0_.equals("blue") ? MapColor.blueColor.colorIndex : (p_getMapColorIndex_0_.equals("brown") ? MapColor.brownColor.colorIndex : (p_getMapColorIndex_0_.equals("green") ? MapColor.greenColor.colorIndex : (p_getMapColorIndex_0_.equals("red") ? MapColor.redColor.colorIndex : (p_getMapColorIndex_0_.equals("black") ? MapColor.blackColor.colorIndex : -1)))))))))))) : MapColor.lightBlueColor.colorIndex)) : MapColor.adobeColor.colorIndex) : MapColor.snowColor.colorIndex)))))))))))))))))))));
    }

    private static int[] getMapColors() {
        MapColor[] amapcolor = MapColor.mapColorArray;
        int[] aint = new int[amapcolor.length];
        Arrays.fill(aint, -1);
        int i = 0;
        while (i < amapcolor.length && i < aint.length) {
            MapColor mapcolor = amapcolor[i];
            if (mapcolor != null) {
                aint[i] = mapcolor.colorValue;
            }
            ++i;
        }
        return aint;
    }

    private static void setMapColors(int[] p_setMapColors_0_) {
        if (p_setMapColors_0_ != null) {
            MapColor[] amapcolor = MapColor.mapColorArray;
            boolean flag = false;
            int i = 0;
            while (i < amapcolor.length && i < p_setMapColors_0_.length) {
                int j;
                MapColor mapcolor = amapcolor[i];
                if (mapcolor != null && (j = p_setMapColors_0_[i]) >= 0 && mapcolor.colorValue != j) {
                    mapcolor.colorValue = j;
                    flag = true;
                }
                ++i;
            }
            if (flag) {
                Minecraft.getMinecraft().getTextureManager().reloadBannerTextures();
            }
        }
    }

    private static int getEntityId(String p_getEntityId_0_) {
        if (p_getEntityId_0_ == null) {
            return -1;
        }
        int i = EntityList.getIDFromString(p_getEntityId_0_);
        if (i < 0) {
            return -1;
        }
        String s = EntityList.getStringFromID(i);
        return !Config.equals(p_getEntityId_0_, s) ? -1 : i;
    }

    private static void dbg(String p_dbg_0_) {
        Config.dbg("CustomColors: " + p_dbg_0_);
    }

    private static void warn(String p_warn_0_) {
        Config.warn("CustomColors: " + p_warn_0_);
    }

    public static int getExpBarTextColor(int p_getExpBarTextColor_0_) {
        return expBarTextColor < 0 ? p_getExpBarTextColor_0_ : expBarTextColor;
    }

    public static int getBossTextColor(int p_getBossTextColor_0_) {
        return bossTextColor < 0 ? p_getBossTextColor_0_ : bossTextColor;
    }

    public static int getSignTextColor(int p_getSignTextColor_0_) {
        return signTextColor < 0 ? p_getSignTextColor_0_ : signTextColor;
    }

    public static interface IColorizer {
        public int getColor(IBlockAccess var1, BlockPos var2);

        public boolean isColorConstant();
    }
}

