/*
 * Decompiled with CFR 0.152.
 */
package fr.velunia.util.configs;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;

public class MacrosConfig {
    private static File file = new File("config/velunia/macros.json");
    private static JsonObject root;

    public static void load() {
        try {
            if (!file.exists() || file.length() == 0L) {
                MacrosConfig.createDefault();
                return;
            }
            FileReader reader = new FileReader(file);
            root = new JsonParser().parse((Reader)reader).getAsJsonObject();
            ((Reader)reader).close();
            int i = 1;
            while (i <= 4) {
                if (!root.has("Macros " + i)) {
                    JsonObject macro = new JsonObject();
                    macro.addProperty("commande", "");
                    root.add("Macros " + i, (JsonElement)macro);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MacrosConfig.createDefault();
        }
    }

    private static void createDefault() {
        root = new JsonObject();
        int i = 1;
        while (i <= 4) {
            JsonObject macro = new JsonObject();
            macro.addProperty("commande", "");
            root.add("Macros " + i, (JsonElement)macro);
            ++i;
        }
        MacrosConfig.save();
    }

    public static void save() {
        try {
            FileWriter writer = new FileWriter(file);
            new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)root, (Appendable)writer);
            ((Writer)writer).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getMacro(int index) {
        String key = "Macros " + (index + 1);
        if (root.has(key)) {
            String cmd = root.getAsJsonObject(key).get("commande").getAsString();
            if (cmd == null || cmd.trim().isEmpty()) {
                return "";
            }
            if (!cmd.startsWith("/")) {
                cmd = "/" + cmd;
            }
            return cmd;
        }
        return "";
    }

    public static void setMacro(int index, String value) {
        String key = "Macros " + (index + 1);
        if (!root.has(key)) {
            JsonObject macro = new JsonObject();
            macro.addProperty("commande", value);
            root.add(key, (JsonElement)macro);
        } else {
            root.getAsJsonObject(key).addProperty("commande", value);
        }
    }
}

