/*
 * Decompiled with CFR 0.152.
 */
package fr.velunia.client.mod.potionhud;

import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class PotionHud
extends Gui {
    private final Minecraft mc = Minecraft.getMinecraft();
    private final int xOffset;
    private final int yOffset;
    private static final ResourceLocation ICONS = new ResourceLocation("textures/gui/container/inventory.png");

    public PotionHud(int xOffset, int yOffset) {
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public void renderHud(int x, int y) {
        if (!this.mc.gameSettings.showDebugInfo) {
            Collection<PotionEffect> effects = this.mc.thePlayer.getActivePotionEffects();
            if (effects.isEmpty()) {
                return;
            }
            int currentY = y;
            for (PotionEffect effect : effects) {
                this.renderPotion(effect, x + this.xOffset, currentY);
                currentY += 17;
            }
        }
    }

    private void renderPotion(PotionEffect effect, int x, int y) {
        Potion potion = Potion.potionTypes[effect.getPotionID()];
        if (potion == null || !potion.hasStatusIcon()) {
            return;
        }
        int iconIndex = potion.getStatusIconIndex();
        this.mc.getTextureManager().bindTexture(ICONS);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawTexturedModalRect(x, y, 0 + iconIndex % 8 * 18, 198 + iconIndex / 8 * 18, 18, 18);
        String timer = this.getPotionDurationString(effect);
        this.mc.fontRendererObj.drawStringWithShadow(timer, x + 20, y + 5, 0xFFFFFF);
    }

    private String getPotionDurationString(PotionEffect effect) {
        int seconds = effect.getDuration() / 20;
        int minutes = seconds / 60;
        return String.format("%d:%02d", minutes, seconds %= 60);
    }

    public int getHeight() {
        return this.mc.thePlayer.getActivePotionEffects().size() * 17;
    }

    public int getWidth() {
        return 40;
    }
}

