/*
 * Decompiled with CFR 0.152.
 */
package fr.velunia.client.mod.keystroke;

import fr.velunia.client.mod.keystroke.GuiScreenKeystrokes;
import fr.velunia.client.mod.keystroke.Key;
import fr.velunia.client.mod.keystroke.MouseButton;
import fr.velunia.util.Config;
import java.awt.Color;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;

public class KeystrokesRenderer {
    public static final int[] COLORS = new int[]{0xFFFFFF, 0xFF0000, 652801, 255, 0xFFFF00, 0xAA00AA};
    private final Minecraft mc = Minecraft.getMinecraft();
    private final Key[] movementKeys = new Key[4];
    private final Key[] spaceKeys = new Key[1];
    private final MouseButton[] mouseButtons = new MouseButton[2];

    public KeystrokesRenderer() {
        this.movementKeys[0] = new Key(this.mc.gameSettings.keyBindForward, 26, 2);
        this.movementKeys[1] = new Key(this.mc.gameSettings.keyBindBack, 26, 26);
        this.movementKeys[2] = new Key(this.mc.gameSettings.keyBindLeft, 2, 26);
        this.movementKeys[3] = new Key(this.mc.gameSettings.keyBindRight, 50, 26);
        this.spaceKeys[0] = new Key(this.mc.gameSettings.keyBindJump, 15, 50);
        this.mouseButtons[0] = new MouseButton(0, 2, 73);
        this.mouseButtons[1] = new MouseButton(1, 38, 73);
    }

    public static void RenderKeyStrokes() throws IOException {
        KeystrokesRenderer k = new KeystrokesRenderer();
        if (Minecraft.getMinecraft().currentScreen != null && Minecraft.getMinecraft().currentScreen instanceof GuiScreenKeystrokes) {
            Minecraft.getMinecraft().currentScreen.handleInput();
        }
    }

    public void renderKeystrokes() {
        Config cfg = Config.getInstance();
        if (cfg.keystrokes.isEnabled()) {
            int height;
            int x = cfg.keystrokes.getX();
            int y = cfg.keystrokes.getY();
            boolean showingMouseButtons = cfg.keystrokes.isShowingMouseButtons();
            boolean showingBarSpace = cfg.keystrokes.isShowingBarSpace();
            ScaledResolution res = new ScaledResolution(Minecraft.getMinecraft());
            int width = 74;
            int n = height = showingMouseButtons ? 88 : 63;
            if (x < 0) {
                cfg.keystrokes.setX(0);
                x = cfg.keystrokes.getX();
            } else if (x > res.getScaledWidth() - width) {
                cfg.keystrokes.setX(res.getScaledWidth() - width);
                x = cfg.keystrokes.getX();
            }
            if (y < 0) {
                cfg.keystrokes.setY(0);
                y = cfg.keystrokes.getY();
            } else if (y > res.getScaledHeight() - height) {
                cfg.keystrokes.setY(res.getScaledHeight() - height);
                y = cfg.keystrokes.getY();
            }
            this.drawMovementKeys(x, y, cfg.keystrokes.getTextColor());
            if (showingMouseButtons) {
                this.drawMouseButtons(x, y, cfg.keystrokes.getTextColor());
            }
            if (showingBarSpace) {
                this.drawSpaceKeys(x, y, cfg.keystrokes.getTextColor());
            }
        }
    }

    public static int getColor(int index, int i) {
        return index == 6 ? Color.HSBtoRGB((float)(System.currentTimeMillis() % 1000L) / 1000.0f, 0.8f, 0.8f) : (index == 7 ? Color.HSBtoRGB((float)(System.currentTimeMillis() % 1000L) / 1000.0f + (float)i / 1000.0f * 4.0f, 0.8f, 0.8f) : COLORS[index]);
    }

    private void drawMovementKeys(int x, int y, int textColor) {
        Key[] var4 = this.movementKeys;
        int var5 = var4.length;
        int var6 = 0;
        while (var6 < var5) {
            Key key = var4[var6];
            key.renderKey(x, y, textColor);
            ++var6;
        }
    }

    private void drawSpaceKeys(int x, int y, int textColor) {
        Key[] var4 = this.spaceKeys;
        int var5 = var4.length;
        int var6 = 0;
        while (var6 < var5) {
            Key key = var4[var6];
            key.renderSpaceKey(x - 13, y, textColor);
            ++var6;
        }
    }

    private void drawMouseButtons(int x, int y, int textColor) {
        MouseButton[] var4 = this.mouseButtons;
        int var5 = var4.length;
        int var6 = 0;
        while (var6 < var5) {
            MouseButton button = var4[var6];
            button.renderMouseButton(x, y, textColor);
            ++var6;
        }
    }
}

