/*
 * Decompiled with CFR 0.152.
 */
package fr.velunia.client.mod.fps;

import fr.velunia.client.mod.fps.FpsRenderer;
import fr.velunia.util.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;

public class Fps {
    private final Minecraft mc = Minecraft.getMinecraft();
    private final int xOffset;
    private final int yOffset;
    private int color = 255;
    private double textBrightness = 1.0;

    public Fps(int xOffset, int yOffset) {
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    public void renderHud(int x, int y, int textColor) {
        Config cfg = Config.getInstance();
        this.mc.mcProfiler.startSection("debug");
        if (Minecraft.debugFPS > 1) {
            this.mc.debug = "" + Minecraft.debugFPS;
        }
        if (!this.mc.gameSettings.showDebugInfo) {
            int bottom;
            int top;
            int right;
            int left;
            FontRenderer fr = this.mc.fontRendererObj;
            String text = this.mc.debug;
            int textWidth = fr.getStringWidth(text);
            int textHeight = fr.FONT_HEIGHT;
            int color = FpsRenderer.getColor(textColor, y + this.yOffset + 8 + x + this.xOffset + 8);
            int red = color >> 16 & 0xFF;
            int green = color >> 8 & 0xFF;
            int blue = color & 0xFF;
            int finalColor = -16777216 + ((int)((double)red * this.textBrightness) << 16) + ((int)((double)green * this.textBrightness) << 8) + (int)((double)blue * this.textBrightness);
            if (cfg.fps.hasBackground()) {
                left = x + this.xOffset - 2;
                right = x + this.xOffset + textWidth + 2;
                top = y + this.yOffset - 2;
                bottom = y + this.yOffset + textHeight + 2;
                Gui.drawRect(left, top, right, bottom, -1341124592);
            }
            left = x + this.xOffset - 2;
            right = x + this.xOffset + textWidth + 2;
            top = y + this.yOffset - 2;
            bottom = y + this.yOffset + textHeight + 2;
            Gui.drawRect(left, top, right, top + 1, finalColor);
            Gui.drawRect(left, bottom - 1, right, bottom, finalColor);
            Gui.drawRect(left, top, left + 1, bottom, finalColor);
            Gui.drawRect(right - 1, top, right, bottom, finalColor);
            fr.drawStringWithShadow(text, x + this.xOffset, y + this.yOffset, finalColor);
        }
    }
}

