/*
 * Decompiled with CFR 0.152.
 */
package fr.velunia.client.mod.coordinateshud;

import fr.velunia.client.mod.coordinateshud.CoordinatesRenderer;
import fr.velunia.util.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;

public class Coordinates {
    private final Minecraft mc = Minecraft.getMinecraft();
    private final int xOffset;
    private final int yOffset;
    private double textBrightness = 1.0;

    public Coordinates(int xOffset, int yOffset) {
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    public void renderHud(int x, int y, int textColor) {
        Config cfg = Config.getInstance();
        if (!this.mc.gameSettings.showDebugInfo) {
            int bottom;
            int top;
            int right;
            int left;
            FontRenderer fr = this.mc.fontRendererObj;
            double posX = this.mc.getRenderViewEntity().posX;
            double posY = this.mc.getRenderViewEntity().posY;
            double posZ = this.mc.getRenderViewEntity().posZ;
            String X = cfg.coordinates.isStreaming() ? "X: Cach\u00e9" : String.format("X: %.0f", posX);
            String Y = String.format("Y: %.0f", posY);
            String Z = cfg.coordinates.isStreaming() ? "Z: Cach\u00e9" : String.format("Z: %.0f", posZ);
            int textWidth = Math.max(fr.getStringWidth(X), Math.max(fr.getStringWidth(Y), fr.getStringWidth(Z)));
            int lineHeight = fr.FONT_HEIGHT + 2;
            int textHeight = lineHeight * 3;
            int color = CoordinatesRenderer.getColor(textColor, y + this.yOffset + 8 + x + this.xOffset + 8);
            int red = color >> 16 & 0xFF;
            int green = color >> 8 & 0xFF;
            int blue = color & 0xFF;
            int finalColor = -16777216 + ((int)((double)red * this.textBrightness) << 16) + ((int)((double)green * this.textBrightness) << 8) + (int)((double)blue * this.textBrightness);
            if (cfg.coordinates.hasBackground()) {
                left = x + this.xOffset - 2;
                right = x + this.xOffset + textWidth + 2;
                top = y + this.yOffset - 2;
                bottom = y + this.yOffset + textHeight + 2;
                Gui.drawRect(left, top, right, bottom, -1341124592);
            }
            left = x + this.xOffset - 2;
            right = x + this.xOffset + textWidth + 2;
            top = y + this.yOffset - 2;
            bottom = y + this.yOffset + textHeight + 2;
            Gui.drawRect(left, top, right, top + 1, finalColor);
            Gui.drawRect(left, bottom - 1, right, bottom, finalColor);
            Gui.drawRect(left, top, left + 1, bottom, finalColor);
            Gui.drawRect(right - 1, top, right, bottom, finalColor);
            fr.drawStringWithShadow(X, x + this.xOffset, y + this.yOffset, color);
            fr.drawStringWithShadow(Y, x + this.xOffset, y + this.yOffset + lineHeight, color);
            fr.drawStringWithShadow(Z, x + this.xOffset, y + this.yOffset + lineHeight * 2, color);
        }
    }

    public int getWidth() {
        FontRenderer fr = this.mc.fontRendererObj;
        String X = String.format("X: %.0f", this.mc.getRenderViewEntity().posX);
        String Y = String.format("Y: %.0f", this.mc.getRenderViewEntity().posY);
        String Z = String.format("Z: %.0f", this.mc.getRenderViewEntity().posZ);
        int textWidth = Math.max(fr.getStringWidth(X), Math.max(fr.getStringWidth(Y), fr.getStringWidth(Z)));
        return textWidth + 4;
    }

    public int getHeight() {
        FontRenderer fr = this.mc.fontRendererObj;
        int lineHeight = fr.FONT_HEIGHT + 2;
        return lineHeight * 3 + 4;
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public int getYOffset() {
        return this.yOffset;
    }
}

