/*
 * Decompiled with CFR 0.152.
 */
package fr.velunia.client.mod.claimhud;

import fr.velunia.client.mod.claimhud.ClaimHudRenderer;
import fr.velunia.network.packet.read.PlayerInfoPacket;
import fr.velunia.util.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;

public class ClaimHud {
    private final Minecraft mc = Minecraft.getMinecraft();
    private EntityPlayerSP sp;
    private final int xOffset;
    private final int yOffset;
    private int color = 255;
    private double textBrightness = 1.0;

    public ClaimHud(int xOffset, int yOffset) {
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    public void renderHud(int x, int y, int textColor) {
        Config cfg = Config.getInstance();
        if (!this.mc.gameSettings.showDebugInfo) {
            FontRenderer fr = this.mc.fontRendererObj;
            String claim = PlayerInfoPacket.getClaim();
            if (claim == null || claim.trim().isEmpty()) {
                claim = "Wilderness";
            }
            int textWidth = fr.getStringWidth(claim);
            int textHeight = fr.FONT_HEIGHT;
            int color = ClaimHudRenderer.getColor(textColor, y + this.yOffset + 8 + x + this.xOffset + 8);
            int red = color >> 16 & 0xFF;
            int green = color >> 8 & 0xFF;
            int blue = color & 0xFF;
            int finalColor = -16777216 + ((int)((double)red * this.textBrightness) << 16) + ((int)((double)green * this.textBrightness) << 8) + (int)((double)blue * this.textBrightness);
            int left = x + this.xOffset - 2;
            int right = x + this.xOffset + textWidth + 2;
            int top = y + this.yOffset - 2;
            int bottom = y + this.yOffset + textHeight + 2;
            if (cfg.claim.hasBackground()) {
                Gui.drawRect(left, top, right, bottom, -1341124592);
            }
            Gui.drawRect(left, top, right, top + 1, finalColor);
            Gui.drawRect(left, bottom - 1, right, bottom, finalColor);
            Gui.drawRect(left, top, left + 1, bottom, finalColor);
            Gui.drawRect(right - 1, top, right, bottom, finalColor);
            fr.drawStringWithShadow(claim, x + this.xOffset, y + this.yOffset, finalColor);
        }
    }

    public int getWidth() {
        FontRenderer fr = this.mc.fontRendererObj;
        String claim = PlayerInfoPacket.getClaim();
        if (claim == null || claim.trim().isEmpty()) {
            claim = "Wilderness";
        }
        int textWidth = fr.getStringWidth(claim);
        return textWidth + 4;
    }

    public int getHeight() {
        FontRenderer fr = this.mc.fontRendererObj;
        int lineHeight = fr.FONT_HEIGHT + 4;
        return lineHeight;
    }
}

