/*
 * Decompiled with CFR 0.152.
 */
package fr.velunia.client.gui.button;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;

public class GuiButtonColorCycle
extends GuiButton {
    private int index;
    private final String[] colors;
    private final String label;

    public GuiButtonColorCycle(int id, int x, int y, int w, int h, String label, String[] colors, int initialIndex) {
        super(id, x, y, w, h, "");
        this.colors = colors;
        this.label = label;
        this.index = initialIndex;
        this.updateDisplayString();
    }

    public void nextColor() {
        ++this.index;
        if (this.index >= this.colors.length) {
            this.index = 0;
        }
        this.updateDisplayString();
    }

    public int getIndex() {
        return this.index;
    }

    private void updateDisplayString() {
        this.displayString = String.valueOf(this.label) + " " + this.colors[this.index];
    }

    @Override
    public void drawButton(Minecraft mc, int mouseX, int mouseY) {
        if (this.visible) {
            boolean hovered = mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
            int bg = hovered ? -1717986919 : -1877995504;
            GuiButtonColorCycle.drawRect(this.xPosition, this.yPosition, this.xPosition + this.width, this.yPosition + this.height, bg);
            mc.fontRendererObj.drawStringWithShadow(this.displayString, this.xPosition + 6, this.yPosition + (this.height - 8) / 2, 0xFFFFFF);
        }
    }
}

