/*
 * Decompiled with CFR 0.152.
 */
package fr.velunia.client.gui.button;

import fr.velunia.util.Colors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Timer;

public class GuiButtonColor
extends GuiButton {
    private static final String __OBFID = "CL_00000672";
    public final int coord1;
    public final int coord2;
    public final int longeur;
    public final int longeur2;
    private int color = 255;
    public String texte;
    private Timer timer = new Timer(50.0f);
    private int step;
    private RenderItem itemRenderer;

    public GuiButtonColor(int buttonId, int x, int y, int largeur, int largeur2, String text, int color) {
        super(buttonId, x, y, largeur, largeur2, text);
        this.coord1 = x;
        this.coord2 = y;
        this.longeur = largeur;
        this.longeur2 = largeur2;
        this.texte = text;
        this.step = 0;
        this.color = color;
    }

    @Override
    public void drawButton(Minecraft mc, int mouseX, int mouseY) {
        if (this.enabled) {
            int xPosition = this.xPosition;
            int yPosition = this.yPosition;
            int width = this.width;
            int height = this.height;
            GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
            boolean hovered = mouseX >= xPosition && mouseY >= yPosition && mouseX < xPosition + width && mouseY < yPosition + height;
            this.timer.updateTimer();
            if (!hovered) {
                GlStateManager.enableBlend();
                GlStateManager.tryBlendFuncSeparate(770, 771, 1, 0);
                GlStateManager.blendFunc(770, 771);
                GuiButtonColor.drawRect(this.coord1 - this.step, this.coord2, this.coord1 + this.longeur + this.step, this.coord2 + this.longeur2, Colors.getShopItemFont());
                this.drawRectangle(this.coord1 - this.step, this.coord2, this.coord1 + this.longeur + this.step, this.coord2 + this.longeur2, this.color);
                this.drawCenteredString(mc.fontRendererObj, this.texte, xPosition + width / 2, yPosition + (height - 8) / 2, Colors.getWhite().getRGB());
            } else {
                GlStateManager.enableBlend();
                GlStateManager.tryBlendFuncSeparate(770, 771, 1, 0);
                GlStateManager.blendFunc(770, 771);
                GuiButtonColor.drawRect(this.coord1 - this.step, this.coord2, this.coord1 + this.longeur + this.step, this.coord2 + this.longeur2, Colors.getShopItemFont());
                this.drawRectangle(this.coord1 - this.step, this.coord2, this.coord1 + this.longeur + this.step, this.coord2 + this.longeur2, this.color);
                this.drawCenteredString(mc.fontRendererObj, this.texte, xPosition + width / 2, yPosition + (height - 8) / 2, Colors.getWhite().getRGB());
            }
            int j = 0;
            while (j < this.timer.elapsedTicks) {
                if (!hovered) {
                    if (this.step != 0) {
                        --this.step;
                    }
                } else if (this.step != 10) {
                    ++this.step;
                }
                ++j;
            }
            this.mouseDragged(mc, mouseX, mouseY);
        }
    }

    @Override
    public void playPressSound(SoundHandler soundHandlerIn) {
        soundHandlerIn.playSound(PositionedSoundRecord.create(new ResourceLocation("gui.button.press"), 1.0f));
    }

    @Override
    public boolean mousePressed(Minecraft mc, int mouseX, int mouseY) {
        return this.enabled && this.visible && mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
    }

    @Override
    protected void mouseDragged(Minecraft mc, int mouseX, int mouseY) {
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY) {
    }

    @Override
    public boolean isMouseOver() {
        return this.hovered;
    }

    @Override
    protected int getHoverState(boolean mouseOver) {
        int i = 1;
        if (!this.enabled) {
            i = 0;
        } else if (mouseOver) {
            i = 2;
        }
        return i;
    }
}

