/*
 * Decompiled with CFR 0.152.
 */
package fr.velunia.client.gui;

import fr.velunia.network.packet.read.PlayerInfoPacket;
import fr.velunia.network.profile.StaffList;
import fr.velunia.util.Colors;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.network.NetworkPlayerInfo;

public class GuiPlayerTabOverlayVelunia
extends Gui {
    private final Minecraft mc;
    private long lastUpdateTime = 0L;
    private final long updateInterval = 2000L;

    public GuiPlayerTabOverlayVelunia(Minecraft mc) {
        this.mc = mc;
    }

    public void renderOverlay() {
        if (!this.mc.gameSettings.keyBindPlayerList.isKeyDown()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastUpdateTime > 2000L) {
            this.lastUpdateTime = currentTime;
        }
        Collection<NetworkPlayerInfo> players = this.mc.getNetHandler().getPlayerInfoMap();
        List<String> onlineStaff = this.getOnlineStaff(players);
        int width = 250;
        int playerSectionHeight = 70;
        int staffSectionHeight = 15 + (onlineStaff.isEmpty() ? 15 : onlineStaff.size() * 15) + 5;
        int totalHeight = playerSectionHeight + staffSectionHeight;
        int x = this.mc.displayWidth / 4 - width / 2;
        int y = 10;
        GuiPlayerTabOverlayVelunia.drawRect(x, y, x + width, y + totalHeight, new Color(0, 0, 0, 120).getRGB());
        int borderColor = Colors.getBorder().getRGB();
        int thickness = 1;
        GuiPlayerTabOverlayVelunia.drawRect(x - thickness, y - thickness, x + width + thickness, y, borderColor);
        GuiPlayerTabOverlayVelunia.drawRect(x - thickness, y + totalHeight, x + width + thickness, y + totalHeight + thickness, borderColor);
        GuiPlayerTabOverlayVelunia.drawRect(x - thickness, y, x, y + totalHeight, borderColor);
        GuiPlayerTabOverlayVelunia.drawRect(x + width, y, x + width + thickness, y + totalHeight, borderColor);
        int baseY = y + 5;
        String name = this.mc.thePlayer.getName();
        String grade = PlayerInfoPacket.getGrade();
        String faction = PlayerInfoPacket.getFaction();
        String money = String.format("%.2f", PlayerInfoPacket.getMoney());
        String claim = PlayerInfoPacket.getClaim();
        if (faction == null || faction.trim().isEmpty()) {
            faction = "Wilderness";
        }
        this.mc.fontRendererObj.drawStringWithShadow("\u00a77Pseudo: \u00a76" + name, x + 10, baseY, 0xFFFFFF);
        this.mc.fontRendererObj.drawStringWithShadow("\u00a77Grade: \u00a7f" + grade, x + 10, baseY + 12, 0xFFFFFF);
        this.mc.fontRendererObj.drawStringWithShadow("\u00a77Faction: \u00a7e" + faction, x + 10, baseY + 24, 0xFFFFFF);
        this.mc.fontRendererObj.drawStringWithShadow("\u00a77Money: \u00a76" + money + "$", x + 10, baseY + 36, 0xFFFFFF);
        this.mc.fontRendererObj.drawStringWithShadow("\u00a77Claim: \u00a76" + claim, x + 10, baseY + 48, 0xFFFFFF);
        int staffY = baseY + 60;
        this.mc.fontRendererObj.drawStringWithShadow("\u00a7dStaff en ligne :", x + 10, staffY, 0xFFFFFF);
        int j = 1;
        if (onlineStaff.isEmpty()) {
            this.mc.fontRendererObj.drawStringWithShadow("\u00a77Aucun staff en ligne", x + 10, staffY + j++ * 15, 0xAAAAAA);
        } else {
            for (String staffName : onlineStaff) {
                this.mc.fontRendererObj.drawStringWithShadow("\u00a7f- \u00a7b" + staffName, x + 10, staffY + j++ * 15, 0xFFFFFF);
            }
        }
    }

    private List<String> getOnlineStaff(Collection<NetworkPlayerInfo> players) {
        ArrayList<String> online = new ArrayList<String>();
        StaffList[] staffListArray = StaffList.values();
        int n = staffListArray.length;
        int n2 = 0;
        while (n2 < n) {
            StaffList staff = staffListArray[n2];
            for (NetworkPlayerInfo info : players) {
                if (!info.getGameProfile().getName().equalsIgnoreCase(staff.getName())) continue;
                online.add(staff.getName());
                break;
            }
            ++n2;
        }
        return online;
    }
}

