/*
 * Decompiled with CFR 0.152.
 */
package fr.velunia.client.gui;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import fr.velunia.util.Colors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.entity.Entity;
import net.minecraft.src.Reflector;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.Chunk;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

public class GuiOverlayDebugVelunia
extends Gui {
    private final Minecraft mc;
    private final FontRenderer fontRenderer;
    private static final String __OBFID = "CL_00001956";

    public GuiOverlayDebugVelunia(Minecraft mc) {
        this.mc = mc;
        this.fontRenderer = mc.fontRendererObj;
    }

    public void renderDebugInfo(ScaledResolution scaledResolutionIn) {
        this.mc.mcProfiler.startSection("debug");
        GlStateManager.pushMatrix();
        this.renderDebugInfoLeft();
        GlStateManager.popMatrix();
        this.mc.mcProfiler.endSection();
    }

    private boolean isReducedDebug() {
        return this.mc.thePlayer.hasReducedDebug() || this.mc.gameSettings.reducedDebugInfo;
    }

    protected void renderDebugInfoLeft() {
        List list = this.call();
        int i = 0;
        while (i < list.size()) {
            String s = (String)list.get(i);
            if (!Strings.isNullOrEmpty((String)s)) {
                int j = this.fontRenderer.FONT_HEIGHT;
                int k = this.fontRenderer.getStringWidth(s);
                boolean flag = true;
                int l = 2 + j * i;
                GuiOverlayDebugVelunia.drawRect(1, l - 1, 2 + k + 1, l + j - 1, Colors.getBackgroundShop());
                this.fontRenderer.drawString(s, 2, l, 0xE0E0E0);
            }
            ++i;
        }
    }

    protected List call() {
        BlockPos blockpos = new BlockPos(this.mc.getRenderViewEntity().posX, this.mc.getRenderViewEntity().getEntityBoundingBox().minY, this.mc.getRenderViewEntity().posZ);
        Chunk chunk = this.mc.theWorld.getChunkFromBlockCoords(blockpos);
        Entity entity = this.mc.getRenderViewEntity();
        EnumFacing enumfacing = entity.getHorizontalFacing();
        if (Minecraft.debugFPS > 70) {
            this.mc.debug = "\u00a72" + Minecraft.debugFPS + " \u00a76FPS\u00a7r";
        } else if (Minecraft.debugFPS > 50 && Minecraft.debugFPS < 71) {
            this.mc.debug = "\u00a7a" + Minecraft.debugFPS + " \u00a76FPS\u00a7r";
        } else if (Minecraft.debugFPS > 30 && Minecraft.debugFPS < 51) {
            this.mc.debug = "\u00a76" + Minecraft.debugFPS + " \u00a76FPS\u00a7r";
        } else if (Minecraft.debugFPS > 10 && Minecraft.debugFPS < 31) {
            this.mc.debug = "\u00a7c" + Minecraft.debugFPS + " \u00a76FPS\u00a7r";
        } else if (Minecraft.debugFPS < 11) {
            this.mc.debug = "\u00a74" + Minecraft.debugFPS + " \u00a76FPS\u00a7r";
        }
        ArrayList arraylist = Lists.newArrayList((Object[])new String[]{"\u00a78[\u00a75Velunia-mc\u00a78] \u00a78[" + this.mc.debug + "\u00a78]", String.format("\u00a78[\u00a7cX\u00a78]\u00a77:\u00a76 %.0f", this.mc.getRenderViewEntity().posX), String.format("\u00a78[\u00a7cY\u00a78]\u00a77:\u00a76 %.0f", this.mc.getRenderViewEntity().posY), String.format("\u00a78[\u00a7cZ\u00a78]\u00a77:\u00a76 %.0f", this.mc.getRenderViewEntity().posZ)});
        arraylist.add("\u00a78[\u00a7cBiome\u00a78]\u00a77:\u00a76 " + chunk.getBiome((BlockPos)blockpos, (WorldChunkManager)this.mc.theWorld.getWorldChunkManager()).biomeName);
        if (enumfacing == EnumFacing.NORTH) {
            arraylist.add("\u00a78[\u00a7cDirection\u00a78]\u00a77:\u00a76 Nord");
        } else if (enumfacing == EnumFacing.SOUTH) {
            arraylist.add("\u00a78[\u00a7cDirection\u00a78]\u00a77:\u00a76 Sud");
        } else if (enumfacing == EnumFacing.WEST) {
            arraylist.add("\u00a78[\u00a7cDirection\u00a78]\u00a77:\u00a76 Ouest");
        } else if (enumfacing == EnumFacing.EAST) {
            arraylist.add("\u00a78[\u00a7cDirection\u00a78]\u00a77:\u00a76 Est");
        }
        return arraylist;
    }

    protected List getDebugInfoRight() {
        long i = Runtime.getRuntime().maxMemory();
        long j = Runtime.getRuntime().totalMemory();
        long k = Runtime.getRuntime().freeMemory();
        long l = j - k;
        ArrayList arraylist = Lists.newArrayList((Object[])new String[]{String.format("Java: %s %dbit", System.getProperty("java.version"), this.mc.isJava64bit() ? 64 : 32), String.format("Mem: % 2d%% %03d/%03dMB", l * 100L / i, GuiOverlayDebugVelunia.bytesToMb(l), GuiOverlayDebugVelunia.bytesToMb(i)), String.format("Allocated: % 2d%% %03dMB", j * 100L / i, GuiOverlayDebugVelunia.bytesToMb(j)), "", String.format("CPU: %s", OpenGlHelper.func_183029_j()), "", String.format("Display: %dx%d (%s)", Display.getWidth(), Display.getHeight(), GL11.glGetString((int)7936)), GL11.glGetString((int)7937), GL11.glGetString((int)7938)});
        if (Reflector.FMLCommonHandler_getBrandings.exists()) {
            Object object = Reflector.call(Reflector.FMLCommonHandler_instance, new Object[0]);
            arraylist.add("");
            arraylist.addAll((Collection)Reflector.call(object, Reflector.FMLCommonHandler_getBrandings, false));
        }
        if (this.isReducedDebug()) {
            return arraylist;
        }
        if (this.mc.objectMouseOver != null && this.mc.objectMouseOver.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK && this.mc.objectMouseOver.getBlockPos() != null) {
            BlockPos blockpos = this.mc.objectMouseOver.getBlockPos();
            IBlockState iblockstate = this.mc.theWorld.getBlockState(blockpos);
            if (this.mc.theWorld.getWorldType() != WorldType.DEBUG_WORLD) {
                iblockstate = iblockstate.getBlock().getActualState(iblockstate, this.mc.theWorld, blockpos);
            }
            arraylist.add("");
            arraylist.add(String.valueOf(Block.blockRegistry.getNameForObject(iblockstate.getBlock())));
            for (Map.Entry entry : iblockstate.getProperties().entrySet()) {
                String s = ((Comparable)entry.getValue()).toString();
                if (entry.getValue() == Boolean.TRUE) {
                    s = (Object)((Object)EnumChatFormatting.GREEN) + s;
                } else if (entry.getValue() == Boolean.FALSE) {
                    s = (Object)((Object)EnumChatFormatting.RED) + s;
                }
                arraylist.add(String.valueOf(((IProperty)entry.getKey()).getName()) + ": " + s);
            }
        }
        return arraylist;
    }

    private static long bytesToMb(long bytes) {
        return bytes / 1024L / 1024L;
    }

    protected void renderDebugInfoRight(ScaledResolution p_175239_1_) {
        List list = this.getDebugInfoRight();
        int i = 0;
        while (i < list.size()) {
            String s = (String)list.get(i);
            if (!Strings.isNullOrEmpty((String)s)) {
                int j = this.fontRenderer.FONT_HEIGHT;
                int k = this.fontRenderer.getStringWidth(s);
                int l = p_175239_1_.getScaledWidth() - 2 - k;
                int i1 = 2 + j * i;
                GuiOverlayDebugVelunia.drawRect(l - 1, i1 - 1, l + k + 1, i1 + j - 1, -1873784752);
                this.fontRenderer.drawString(s, l, i1, 0xE0E0E0);
            }
            ++i;
        }
    }
}

