/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.json;

import com.azul.crs.json.JSONSerializer;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DummyJSONSerializer
implements JSONSerializer {
    private final int tabs = 2;
    private boolean doFormat = Boolean.getBoolean("com.azul.crs.client.enablePrettyPrint");
    private int level = 0;
    private static final String escape3Text = "\"\\/\b\f\n\r\t";
    private static final Pattern escape3Pattern = Pattern.compile("[\"\\\\/\b\f\n\r\t\u0000-\u001f]");
    private static final String[] escape3Replacement = new String[]{"\\\\\"", "\\\\\\\\", "\\\\/", "\\\\b", "\\\\f", "\\\\n", "\\\\r", "\\\\t"};

    public DummyJSONSerializer() {
    }

    public DummyJSONSerializer(boolean bl) {
        this.doFormat |= bl;
    }

    void formatEnter(PrintStream printStream) {
        if (!this.doFormat) {
            return;
        }
        ++this.level;
    }

    void formatMid(PrintStream printStream) throws IOException {
        if (!this.doFormat) {
            return;
        }
        printStream.append("\n");
        for (int i = 0; i < 2 * this.level; ++i) {
            printStream.append(' ');
        }
    }

    void formatLeave(PrintStream printStream) {
        if (!this.doFormat) {
            return;
        }
        --this.level;
    }

    private static boolean fieldFilter(Field field) {
        if (Modifier.isTransient(field.getModifiers())) {
            return false;
        }
        if (Modifier.isStatic(field.getModifiers())) {
            return false;
        }
        return !"hash".equals(field.getName()) || !"java.lang.String".equals(field.getDeclaringClass().getName());
    }

    void serializeEnum(PrintStream printStream, Enum enum_) throws IOException {
        printStream.append('\"').append(enum_.name()).append('\"');
    }

    private static boolean isNumberOrBoolean(Object object) {
        return object instanceof Number || object instanceof Boolean;
    }

    void serializeNumberOrBoolean(PrintStream printStream, Object object) throws IOException {
        printStream.append(object.toString());
    }

    void serializeString(PrintStream printStream, String string) throws IOException {
        Matcher matcher = escape3Pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        printStream.append('\"');
        while (matcher.find()) {
            char c = matcher.group().charAt(0);
            int n = escape3Text.indexOf(c);
            stringBuffer.setLength(0);
            matcher.appendReplacement(stringBuffer, n >= 0 ? escape3Replacement[n] : String.format("\\\\u%04x", c));
            printStream.append(stringBuffer);
        }
        stringBuffer.setLength(0);
        matcher.appendTail(stringBuffer);
        printStream.append(stringBuffer);
        printStream.append('\"');
    }

    void serializeMap(PrintStream printStream, Map map) throws IOException {
        printStream.append('{');
        this.formatEnter(printStream);
        int n = 0;
        for (Object k : map.keySet()) {
            Object v = map.get(k);
            if (v == null) continue;
            if (n > 0) {
                printStream.append(',');
            }
            this.formatMid(printStream);
            ++n;
            this.serialize(printStream, k);
            printStream.append(':');
            this.serialize(printStream, v);
        }
        this.formatLeave(printStream);
        if (n > 0) {
            this.formatMid(printStream);
        }
        printStream.append('}');
    }

    void serializeCollection(PrintStream printStream, Collection collection) throws IOException {
        printStream.append('[');
        this.formatEnter(printStream);
        int n = 0;
        for (Object e : collection) {
            if (n > 0) {
                printStream.append(',');
            }
            this.formatMid(printStream);
            ++n;
            this.serialize(printStream, e);
        }
        this.formatLeave(printStream);
        if (n > 0) {
            this.formatMid(printStream);
        }
        printStream.append(']');
    }

    private void printFieldName(PrintStream printStream, Field field) throws IOException {
        this.serializeString(printStream, field.getName());
    }

    void serializeObject(PrintStream printStream, Object object) throws IOException {
        if (null == object) {
            printStream.append("null");
            return;
        }
        printStream.append('{');
        this.formatEnter(printStream);
        Class<?> clazz = object.getClass();
        int n = 0;
        for (Field field : clazz.getDeclaredFields()) {
            if (!DummyJSONSerializer.fieldFilter(field)) continue;
            field.setAccessible(true);
            Object object2 = null;
            try {
                object2 = field.get(object);
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace(System.err);
                throw new RuntimeException("Tykwa: ", illegalAccessException);
            }
            if (object2 == null) continue;
            if (n > 0) {
                printStream.append(',');
            }
            this.formatMid(printStream);
            this.printFieldName(printStream, field);
            printStream.append(':');
            this.serialize(printStream, object2);
            ++n;
        }
        this.formatLeave(printStream);
        if (n > 0) {
            this.formatMid(printStream);
        }
        printStream.append('}');
    }

    @Override
    public void serialize(PrintStream printStream, Object object) throws IOException {
        if (null == object) {
            return;
        }
        if (object instanceof String) {
            this.serializeString(printStream, (String)object);
        } else if (object instanceof Enum) {
            this.serializeEnum(printStream, (Enum)object);
        } else if (DummyJSONSerializer.isNumberOrBoolean(object)) {
            this.serializeNumberOrBoolean(printStream, object);
        } else if (object instanceof Map) {
            this.serializeMap(printStream, (Map)object);
        } else if (object instanceof Collection) {
            this.serializeCollection(printStream, (Collection)object);
        } else {
            this.serializeObject(printStream, object);
        }
    }
}

