/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.digest;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

final class ConstantPool {
    private final Map<Integer, Integer> dedup;
    private final ConstantPoolEntry[] entries;
    private static ThreadLocal<Map<String, Integer>> tmpRef = ThreadLocal.withInitial(HashMap::new);
    private static ThreadLocal<StringBuilder> sbRef = ThreadLocal.withInitial(StringBuilder::new);

    private ConstantPool(ConstantPoolEntry[] constantPoolEntryArray) {
        this.entries = constantPoolEntryArray;
        this.dedup = new HashMap<Integer, Integer>();
        Map<String, Integer> map = tmpRef.get();
        map.clear();
        StringBuilder stringBuilder = sbRef.get();
        for (int i = 0; i < constantPoolEntryArray.length; ++i) {
            ConstantPoolEntry constantPoolEntry = constantPoolEntryArray[i];
            if (constantPoolEntry == null) continue;
            stringBuilder.setLength(0);
            constantPoolEntry.toString(stringBuilder, constantPoolEntryArray);
            String string = stringBuilder.toString();
            Integer n = map.get(string);
            if (n != null) {
                this.dedup.put(i, n);
                continue;
            }
            map.put(string, i);
        }
    }

    public static ConstantPool readConstantPool(DataInputStream dataInputStream) throws IOException {
        ConstantType constantType;
        ConstantPoolEntry[] constantPoolEntryArray = new ConstantPoolEntry[dataInputStream.readUnsignedShort()];
        for (int i = 1; i < constantPoolEntryArray.length; i += constantType.slots()) {
            ConstantPoolEntry constantPoolEntry;
            constantType = ConstantType.values()[dataInputStream.readByte()];
            constantPoolEntryArray[i] = constantPoolEntry = ((ConstantPoolEntry)constantType.supplier.get()).read(dataInputStream);
        }
        return new ConstantPool(constantPoolEntryArray);
    }

    int dedup(int n) {
        return this.dedup.getOrDefault(n, n);
    }

    public String getStringConstant(int n) {
        return ((ConstantUtf8Entry)this.entries[n]).str;
    }

    public String getClassShortName(int n) {
        if (n > 0) {
            int n2 = ((ConstantClassEntry)this.entries[n]).name;
            String string = ((ConstantUtf8Entry)this.entries[n2]).str;
            int n3 = string.lastIndexOf(47);
            return n3 < 0 ? string : string.substring(n3 + 1);
        }
        return "";
    }

    private static class ConstantPackageEntry
    extends ConstantNameEntry {
        private ConstantPackageEntry() {
        }

        @Override
        protected void toStringImpl(StringBuilder stringBuilder, ConstantPoolEntry[] constantPoolEntryArray) {
            stringBuilder.append('f');
            constantPoolEntryArray[this.name_and_type_index].toString(stringBuilder, constantPoolEntryArray);
        }
    }

    private static class ConstantModuleEntry
    extends ConstantNameEntry {
        private ConstantModuleEntry() {
        }

        @Override
        protected void toStringImpl(StringBuilder stringBuilder, ConstantPoolEntry[] constantPoolEntryArray) {
            stringBuilder.append('e');
            constantPoolEntryArray[this.name_and_type_index].toString(stringBuilder, constantPoolEntryArray);
        }
    }

    private static abstract class ConstantNameEntry
    extends ConstantPoolEntry {
        protected int name_and_type_index;

        private ConstantNameEntry() {
        }

        @Override
        protected void readImpl(DataInputStream dataInputStream) throws IOException {
            this.name_and_type_index = dataInputStream.readUnsignedShort();
        }
    }

    private static class ConstantInvokeDynamicEntry
    extends ConstantPoolEntry {
        int bootstrap_method_attr_index;
        int name_and_type_index;

        private ConstantInvokeDynamicEntry() {
        }

        @Override
        protected void readImpl(DataInputStream dataInputStream) throws IOException {
            this.bootstrap_method_attr_index = dataInputStream.readUnsignedShort();
            this.name_and_type_index = dataInputStream.readUnsignedShort();
        }

        @Override
        protected void toStringImpl(StringBuilder stringBuilder, ConstantPoolEntry[] constantPoolEntryArray) {
            stringBuilder.append('d');
            stringBuilder.append(this.bootstrap_method_attr_index);
            constantPoolEntryArray[this.name_and_type_index].toString(stringBuilder, constantPoolEntryArray);
        }
    }

    private static class ConstantMethodTypeEntry
    extends ConstantPoolEntry {
        private int descriptorIndex;

        private ConstantMethodTypeEntry() {
        }

        @Override
        protected void readImpl(DataInputStream dataInputStream) throws IOException {
            this.descriptorIndex = dataInputStream.readUnsignedShort();
        }

        @Override
        protected void toStringImpl(StringBuilder stringBuilder, ConstantPoolEntry[] constantPoolEntryArray) {
            stringBuilder.append('c');
            constantPoolEntryArray[this.descriptorIndex].toString(stringBuilder, constantPoolEntryArray);
        }
    }

    private static class ConstantMethodHandleEntry
    extends ConstantPoolEntry {
        private MethodHandleKind reference_kind;
        private int reference_index;

        private ConstantMethodHandleEntry() {
        }

        @Override
        protected void readImpl(DataInputStream dataInputStream) throws IOException {
            this.reference_kind = MethodHandleKind.values()[dataInputStream.readByte()];
            this.reference_index = dataInputStream.readUnsignedShort();
        }

        @Override
        protected void toStringImpl(StringBuilder stringBuilder, ConstantPoolEntry[] constantPoolEntryArray) {
            stringBuilder.append('b');
            stringBuilder.append((Object)this.reference_kind);
            constantPoolEntryArray[this.reference_index].toString(stringBuilder, constantPoolEntryArray);
        }
    }

    private static class ConstantUtf8Entry
    extends ConstantPoolEntry {
        private String str;

        private ConstantUtf8Entry() {
        }

        @Override
        protected void readImpl(DataInputStream dataInputStream) throws IOException {
            int n = dataInputStream.readUnsignedShort();
            byte[] byArray = new byte[n];
            for (int i = 0; i != n; i += dataInputStream.read(byArray, i, n - i)) {
            }
            this.str = new String(byArray);
        }

        @Override
        protected void toStringImpl(StringBuilder stringBuilder, ConstantPoolEntry[] constantPoolEntryArray) {
            stringBuilder.append('a');
            stringBuilder.append(this.str);
        }
    }

    private static class ConstantNameAndTypeEntry
    extends ConstantPoolEntry {
        private int name_index;
        private int descriptor_index;

        private ConstantNameAndTypeEntry() {
        }

        @Override
        protected void readImpl(DataInputStream dataInputStream) throws IOException {
            this.name_index = dataInputStream.readUnsignedShort();
            this.descriptor_index = dataInputStream.readUnsignedShort();
        }

        @Override
        protected void toStringImpl(StringBuilder stringBuilder, ConstantPoolEntry[] constantPoolEntryArray) {
            stringBuilder.append('9');
            constantPoolEntryArray[this.name_index].toString(stringBuilder, constantPoolEntryArray);
            constantPoolEntryArray[this.descriptor_index].toString(stringBuilder, constantPoolEntryArray);
        }
    }

    private static class ConstantDoubleEntry
    extends ConstantPoolEntry {
        private double value;

        private ConstantDoubleEntry() {
        }

        @Override
        protected void readImpl(DataInputStream dataInputStream) throws IOException {
            this.value = dataInputStream.readDouble();
        }

        @Override
        protected void toStringImpl(StringBuilder stringBuilder, ConstantPoolEntry[] constantPoolEntryArray) {
            stringBuilder.append('8');
            stringBuilder.append(this.value);
        }
    }

    private static class ConstantLongEntry
    extends ConstantPoolEntry {
        private long value;

        private ConstantLongEntry() {
        }

        @Override
        protected void readImpl(DataInputStream dataInputStream) throws IOException {
            this.value = dataInputStream.readLong();
        }

        @Override
        protected void toStringImpl(StringBuilder stringBuilder, ConstantPoolEntry[] constantPoolEntryArray) {
            stringBuilder.append('7');
            stringBuilder.append(this.value);
        }
    }

    private static class ConstantFloatEntry
    extends ConstantPoolEntry {
        private float value;

        private ConstantFloatEntry() {
        }

        @Override
        protected void readImpl(DataInputStream dataInputStream) throws IOException {
            this.value = dataInputStream.readFloat();
        }

        @Override
        protected void toStringImpl(StringBuilder stringBuilder, ConstantPoolEntry[] constantPoolEntryArray) {
            stringBuilder.append('6');
            stringBuilder.append(this.value);
        }
    }

    private static class ConstantIntegerEntry
    extends ConstantPoolEntry {
        private int value;

        private ConstantIntegerEntry() {
        }

        @Override
        protected void readImpl(DataInputStream dataInputStream) throws IOException {
            this.value = dataInputStream.readInt();
        }

        @Override
        protected void toStringImpl(StringBuilder stringBuilder, ConstantPoolEntry[] constantPoolEntryArray) {
            stringBuilder.append('5');
            stringBuilder.append(this.value);
        }
    }

    private static class ConstantStringEntry
    extends ConstantPoolEntry {
        private int string_index;

        private ConstantStringEntry() {
        }

        @Override
        protected void readImpl(DataInputStream dataInputStream) throws IOException {
            this.string_index = dataInputStream.readUnsignedShort();
        }

        @Override
        protected void toStringImpl(StringBuilder stringBuilder, ConstantPoolEntry[] constantPoolEntryArray) {
            stringBuilder.append('4');
            constantPoolEntryArray[this.string_index].toString(stringBuilder, constantPoolEntryArray);
        }
    }

    private static class ConstantInterfaceMethodRefEntry
    extends ConstantRefEntry {
        private ConstantInterfaceMethodRefEntry() {
        }

        @Override
        protected void toStringImpl(StringBuilder stringBuilder, ConstantPoolEntry[] constantPoolEntryArray) {
            stringBuilder.append('3');
            constantPoolEntryArray[this.class_index].toString(stringBuilder, constantPoolEntryArray);
            constantPoolEntryArray[this.name_and_type_index].toString(stringBuilder, constantPoolEntryArray);
        }
    }

    private static class ConstantMethodRefEntry
    extends ConstantRefEntry {
        private ConstantMethodRefEntry() {
        }

        @Override
        protected void toStringImpl(StringBuilder stringBuilder, ConstantPoolEntry[] constantPoolEntryArray) {
            stringBuilder.append('2');
            constantPoolEntryArray[this.class_index].toString(stringBuilder, constantPoolEntryArray);
            constantPoolEntryArray[this.name_and_type_index].toString(stringBuilder, constantPoolEntryArray);
        }
    }

    private static class ConstantFieldRefEntry
    extends ConstantRefEntry {
        private ConstantFieldRefEntry() {
        }

        @Override
        protected void toStringImpl(StringBuilder stringBuilder, ConstantPoolEntry[] constantPoolEntryArray) {
            stringBuilder.append('1');
            constantPoolEntryArray[this.class_index].toString(stringBuilder, constantPoolEntryArray);
            constantPoolEntryArray[this.name_and_type_index].toString(stringBuilder, constantPoolEntryArray);
        }
    }

    private static abstract class ConstantRefEntry
    extends ConstantPoolEntry {
        protected int class_index;
        protected int name_and_type_index;

        private ConstantRefEntry() {
        }

        @Override
        protected void readImpl(DataInputStream dataInputStream) throws IOException {
            this.class_index = dataInputStream.readUnsignedShort();
            this.name_and_type_index = dataInputStream.readUnsignedShort();
        }
    }

    private static class ConstantClassEntry
    extends ConstantPoolEntry {
        private int name;

        private ConstantClassEntry() {
        }

        @Override
        protected void readImpl(DataInputStream dataInputStream) throws IOException {
            this.name = dataInputStream.readUnsignedShort();
        }

        @Override
        protected void toStringImpl(StringBuilder stringBuilder, ConstantPoolEntry[] constantPoolEntryArray) {
            stringBuilder.append('0');
            constantPoolEntryArray[this.name].toString(stringBuilder, constantPoolEntryArray);
        }
    }

    private static abstract class ConstantPoolEntry {
        private ConstantPoolEntry() {
        }

        public ConstantPoolEntry read(DataInputStream dataInputStream) throws IOException {
            this.readImpl(dataInputStream);
            return this;
        }

        protected abstract void readImpl(DataInputStream var1) throws IOException;

        protected final void toString(StringBuilder stringBuilder, ConstantPoolEntry[] constantPoolEntryArray) {
            this.toStringImpl(stringBuilder, constantPoolEntryArray);
        }

        protected abstract void toStringImpl(StringBuilder var1, ConstantPoolEntry[] var2);
    }

    private static enum MethodHandleKind {
        RESERVED_0,
        GET_FIELD,
        GET_STATIC,
        PUT_FIELD,
        PUT_STATIC,
        INVOKE_VIRTUAL,
        INVOKE_STATIC,
        INVOKE_SPECIAL,
        NEW_INVOKE_SPECIAL,
        INVOKE_INTERFACE;

    }

    private static enum ConstantType {
        RESERVED_0,
        UTF8(() -> new ConstantUtf8Entry()),
        RESERVED_2,
        INTEGER(() -> new ConstantIntegerEntry()),
        FLOAT(() -> new ConstantFloatEntry()),
        LONG(() -> new ConstantLongEntry()),
        DOUBLE(() -> new ConstantDoubleEntry()),
        CLASS(() -> new ConstantClassEntry()),
        STRING(() -> new ConstantStringEntry()),
        FIELDREF(() -> new ConstantFieldRefEntry()),
        METHODREF(() -> new ConstantMethodRefEntry()),
        INTERFACEMETHODREF(() -> new ConstantInterfaceMethodRefEntry()),
        NAMEANDTYPE(() -> new ConstantNameAndTypeEntry()),
        RESERVED_13,
        RESERVED_14,
        METHODHANDLE(() -> new ConstantMethodHandleEntry()),
        METHODTYPE(() -> new ConstantMethodTypeEntry()),
        RESERVED_17,
        INVOKEDYNAMIC(() -> new ConstantInvokeDynamicEntry()),
        MODULE(() -> new ConstantModuleEntry()),
        PACKAGE(() -> new ConstantPackageEntry());

        private final Supplier<ConstantPoolEntry> supplier;

        private ConstantType() {
            this(null);
        }

        private ConstantType(Supplier<ConstantPoolEntry> supplier) {
            this.supplier = supplier;
        }

        public int slots() {
            return this == LONG || this == DOUBLE ? 2 : 1;
        }
    }
}

