/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.util;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import sun.net.dns.ResolverConfiguration;

public final class DnsDetect {
    private final List<String> searchlist;
    private final String postfix;

    public DnsDetect(String string) throws IOException {
        this.postfix = string == null ? "" : "_" + string;
        ResolverConfiguration resolverConfiguration = ResolverConfiguration.open();
        this.searchlist = resolverConfiguration.searchlist();
        this.searchlist.add(0, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String query(String string, String string2) {
        try (InitialDirContext initialDirContext = new InitialDirContext();){
            initialDirContext.addToEnvironment("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            Iterator<String> iterator = this.searchlist.iterator();
            while (iterator.hasNext()) {
                String string3 = iterator.next();
                String string4 = string3.isEmpty() ? string : string + "." + string3;
                try {
                    Object object;
                    Attributes attributes = initialDirContext.getAttributes(string4, new String[]{string2});
                    Attribute attribute = attributes.get(string2);
                    if (attribute == null || (object = attribute.get()) == null) continue;
                    String string5 = object.toString();
                    return string5;
                }
                catch (NamingException namingException) {}
            }
            return null;
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return null;
    }

    public String queryEndpoint() throws IOException {
        String string = this.query("az-crs-endpoint" + this.postfix, "CNAME");
        return string == null ? null : (string.endsWith(".") ? string.substring(0, string.length() - 1) : string);
    }

    public String queryMailbox() throws IOException {
        return this.query("az-crs-mailbox" + this.postfix, "TXT");
    }

    public String getRecordNamePostfix() {
        return this.postfix;
    }
}

