/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.service;

import com.azul.crs.client.Utils;
import com.azul.crs.client.models.ServerRequest;
import com.azul.crs.client.service.ClientService;
import com.azul.crs.util.logging.Logger;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public final class ServerRequestsService
implements ClientService {
    private static final Object requestsCountLock = new Object();
    private static final BlockingDeque<ServerRequest> requests = new LinkedBlockingDeque<ServerRequest>();
    private static final Logger log = Logger.getLogger(ServerRequestsService.class);
    private static final ServerRequest stopRequest = new ServerRequest(){

        public String toString() {
            return "StopServerRequestsServiceRequest";
        }
    };
    private static Thread queueProcessingThread = null;
    private static int requestsCount;
    private boolean isRunning;
    private static final Map<Class<? extends ServerRequest>, List<Consumer>> listeners;

    @Override
    public String serviceName() {
        return "requests.processor";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addServiceRequest(ServerRequest serverRequest) {
        log.debug("Adding ServiceRequest: %s", serverRequest);
        Object object = requestsCountLock;
        synchronized (object) {
            ++requestsCount;
            requests.add(serverRequest);
        }
    }

    @Override
    public synchronized void start() {
        if (this.isRunning) {
            return;
        }
        queueProcessingThread = new Thread((Runnable)new ServerRequestsProcessor(), "ServerRequestsProcessor");
        queueProcessingThread.setDaemon(true);
        queueProcessingThread.start();
        this.isRunning = true;
    }

    @Override
    public synchronized void stop(Utils.Deadline deadline) {
        if (!this.isRunning) {
            return;
        }
        ServerRequestsService.addServiceRequest(stopRequest);
        try {
            queueProcessingThread.join(Math.max(1L, deadline.remainder(TimeUnit.MILLISECONDS)));
        }
        catch (InterruptedException interruptedException) {
            Thread.interrupted();
        }
        if (queueProcessingThread.isAlive()) {
            log.debug("Failed to stop ServerRequestsService::queueProcessingThread in time", new Object[0]);
        }
        this.isRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getRequestsCount() {
        Object object = requestsCountLock;
        synchronized (object) {
            return requestsCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void waitAllRequestsProcessed(Utils.Deadline deadline) {
        long l = Utils.currentTimeCount();
        Object object = requestsCountLock;
        synchronized (object) {
            while (!deadline.hasExpired() && ServerRequestsService.getRequestsCount() > 0) {
                try {
                    requestsCountLock.wait(Math.max(1L, deadline.remainder(TimeUnit.MILLISECONDS)));
                }
                catch (InterruptedException interruptedException) {
                    Thread.interrupted();
                    break;
                }
            }
        }
        log.debug("waitAllRequestsProcessed complete%s", Utils.elapsedTimeString(l));
    }

    public void cancel() {
        this.stop(Utils.Deadline.in(0L, TimeUnit.MILLISECONDS));
    }

    public static <T extends ServerRequest> void addListener(Class<T> clazz2, Consumer<T> consumer) {
        listeners.computeIfAbsent(clazz2, clazz -> new LinkedList()).add(consumer);
    }

    static {
        listeners = new HashMap<Class<? extends ServerRequest>, List<Consumer>>();
    }

    private static class ServerRequestsProcessor
    implements Runnable {
        private ServerRequestsProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    ServerRequest serverRequest = (ServerRequest)requests.takeFirst();
                    if (stopRequest == serverRequest) {
                        log.debug("Stop processing ServerRequests", new Object[0]);
                        break;
                    }
                    listeners.entrySet().stream().filter(entry -> serverRequest.getClass().isAssignableFrom((Class)entry.getKey())).forEachOrdered(entry -> ((List)entry.getValue()).forEach(consumer -> this.process((Consumer)consumer, serverRequest)));
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    Thread.interrupted();
                }
                finally {
                    Object object = requestsCountLock;
                    synchronized (object) {
                        requestsCount--;
                        requestsCountLock.notify();
                    }
                    continue;
                }
                break;
            }
        }

        private void process(Consumer consumer, ServerRequest serverRequest) {
            log.debug("Processing server request: %s", serverRequest);
            consumer.accept(serverRequest);
        }
    }
}

