/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.service;

import com.azul.crs.client.Client;
import com.azul.crs.client.Inventory;
import com.azul.crs.client.Utils;
import com.azul.crs.client.models.ServerRequest;
import com.azul.crs.client.models.VMArtifact;
import com.azul.crs.client.models.VMEvent;
import com.azul.crs.client.service.ClientService;
import com.azul.crs.client.service.ServerRequestsService;
import com.azul.crs.digest.Digest;
import com.azul.crs.digest.ShadedClassHashCalculator;
import com.azul.crs.jar.ZipTools;
import com.azul.crs.runtime.utils.DataEntriesMap;
import com.azul.crs.runtime.utils.KnownAzulRuntimeContainers;
import com.azul.crs.runtime.utils.URLHelper;
import com.azul.crs.util.logging.Logger;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;

public final class JarLoadMonitor
implements ClientService {
    private static final boolean DEBUG = Boolean.getBoolean("com.azul.crs.jarload.debug");
    private static final boolean jarLoadByClassLoad = JarLoadMonitor.getBooleanProperty("com.azul.crs.jarload.jarLoadByClassLoad", true);
    private static final boolean sendCentralDirectoryHash = Boolean.getBoolean("com.azul.crs.jarload.sendCentralDirectoryHashOnJarLoad");
    private static final boolean sendJarEntriesHashes = JarLoadMonitor.getBooleanProperty("com.azul.crs.jarload.sendJarEntriesHashesOnJarLoad", true);
    private static final boolean sendJarEntries = JarLoadMonitor.getBooleanProperty("com.azul.crs.jarload.sendJarEntriesOnJarLoad", false);
    private static final boolean sendJarEntriesShadedHashes = JarLoadMonitor.getBooleanProperty("com.azul.crs.jarload.sendJarEntriesShadedHashesOnJarLoad", true);
    private static final boolean sendJarFile = Boolean.getBoolean("com.azul.crs.jarload.sendJarFileOnJarLoad");
    private static final String allowedToSendJarFiles = System.getProperty("com.azul.crs.jarload.allowedToSendJarFilesListOnJarLoad");
    private static final String sendJarEntriesList = System.getProperty("com.azul.crs.jarload.sendJarEntriesListOnJarLoad", "**/META-INF/MANIFEST.MF,**/pom.properties");
    private static final boolean recursiveJarDiscovery = JarLoadMonitor.getBooleanProperty("com.azul.crs.jarload.recursiveJarDiscoveryOnJarLoad", true);
    private static final boolean forceFullJarLoadedEvents = JarLoadMonitor.getBooleanProperty("com.azul.crs.jarload.forceFullJarLoadedEvents", false);
    private static final int dedupSize = JarLoadMonitor.getIntProperty("com.azul.crs.jarload.dedupSize", 100);
    private static final JarLoadMonitor instance = new JarLoadMonitor();
    private Client client;
    private AtomicBoolean started = new AtomicBoolean();
    private volatile Utils.Deadline deadline;
    private final PrintWriter traceOut;
    private final MessageDigest md;
    private ZipTools zt;
    private JarEntryAccess jarEntryAccess;
    private JarFileAccess jarFileAccess;
    private static final Set<String> knownVmJars = JarLoadMonitor.initKnownVmJars();
    private static final Object activeTasksLock = new Object();
    private static final Set<NotificationTask> activeTasks = new HashSet<NotificationTask>();
    private static final String[] alreadyProcessedURLList = new String[dedupSize];
    private static final Set<String> alreadyProcessedURLSet = new HashSet<String>();
    private static int alreadyProcessedIdx = 0;
    private static final int VM_JAR_LOADED_EVENT_INLINE_PAYLOAD_THRESHOLD = 524288;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAlreadyProcessed(String string) {
        String[] stringArray = alreadyProcessedURLList;
        synchronized (alreadyProcessedURLList) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return alreadyProcessedURLSet.contains(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAlreadyProcessed(String string) {
        String[] stringArray = alreadyProcessedURLList;
        synchronized (alreadyProcessedURLList) {
            if (alreadyProcessedURLSet.add(string)) {
                String string2 = alreadyProcessedURLList[alreadyProcessedIdx];
                if (string2 != null) {
                    alreadyProcessedURLSet.remove(string2);
                }
                JarLoadMonitor.alreadyProcessedURLList[JarLoadMonitor.alreadyProcessedIdx] = string;
                alreadyProcessedIdx = (alreadyProcessedIdx + 1) % alreadyProcessedURLList.length;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private JarLoadMonitor() {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.logger().error("Failed to initialize SHA-256 MessageDigest: %s", noSuchAlgorithmException);
            this.stop(Utils.Deadline.in(0L, TimeUnit.MILLISECONDS));
        }
        this.md = messageDigest;
        this.zt = ZipTools.createDefault();
        this.jarEntryAccess = new JarEntryAccess(sendJarEntriesList);
        this.jarFileAccess = new JarFileAccess(allowedToSendJarFiles);
        PrintWriter printWriter = null;
        if (this.logger().isEnabled(Logger.Level.TRACE)) {
            try {
                Path path = Files.createTempFile("CRSJarLoadMonitor", ".log", new FileAttribute[0]);
                this.logger().trace("writing JarLoadMonitor trace to file %s", path);
                printWriter = new PrintWriter(Files.newBufferedWriter(path, new OpenOption[0]));
            }
            catch (IOException iOException) {
                this.logger().error("Cannot trace events into file: %s", iOException);
            }
        }
        this.traceOut = printWriter;
    }

    public static JarLoadMonitor getInstance(Client client) {
        JarLoadMonitor.instance.client = client;
        return instance;
    }

    private VMEvent<Map> jarLoadEvent(String string, InitiatedBy initiatedBy, int n, String string2, long l, String string3, String string4, String string5, Long l2, List<String> list, Set<MavenComponent> set, Map<String, Long> map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("url", string);
        hashMap.put("jarName", string2);
        hashMap.put("centralDirectoryHash", string3);
        hashMap.put("manifestHash", string4);
        hashMap.put("centralDirectoryExtractionMethod", string5);
        hashMap.put("centralDirectoryLength", l2 != null ? Long.toString(l2) : null);
        hashMap.put("entries", list);
        hashMap.put("initiatedBy", (Object)initiatedBy);
        hashMap.put("recursionDepth", n);
        hashMap.put("mavenComponents", set);
        hashMap.put("stats", map);
        return new VMEvent().eventType(VMEvent.Type.VM_JAR_LOADED).eventTime(l).eventPayload(hashMap);
    }

    @Override
    public synchronized void start() {
        if (!this.started.compareAndSet(false, true)) {
            this.logger().error("JarLoadMonitor has been started already", new Object[0]);
            return;
        }
        if (this.hardstop()) {
            return;
        }
        ServerRequestsService.addListener(ServerRequest.VmJarInfoRequest.class, vmJarInfoRequest -> {
            if (this.hardstop()) {
                return;
            }
            NotificationTask notificationTask = new NotificationTask(vmJarInfoRequest.getPath());
            boolean bl = false;
            try {
                this.addActiveTask(notificationTask);
                String string = vmJarInfoRequest.getPath();
                try (JarFile jarFile = new JarFile(string, false);){
                    bl = this.postVMJarLoadedEvent(new URL("file://" + string), jarFile, vmJarInfoRequest.getUrl(), InitiatedBy.SERVER_REQUEST, 0, true);
                }
                catch (IOException iOException) {
                    this.logger().error("Exception %s", iOException);
                }
            }
            finally {
                notificationTask.setCompletionStatus(bl);
                this.removeActiveTask(notificationTask);
            }
        });
    }

    @Override
    public synchronized void stop(Utils.Deadline deadline) {
        this.deadline = deadline;
        try {
            while (!(this.hardstop() || ServerRequestsService.getRequestsCount() <= 0 && VMEvent.Type.VM_JAR_LOADED.getInFlightEventsCounter() <= 0)) {
                ServerRequestsService.waitAllRequestsProcessed(deadline);
                VMEvent.Type.VM_JAR_LOADED.waitAllEventsProcessed(deadline);
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.interrupted();
        }
        this.waitActiveTasks(deadline);
        if (this.traceOut != null) {
            this.traceOut.close();
        }
    }

    private boolean hardstop() {
        return this.deadline != null && this.deadline.hasExpired();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addActiveTask(NotificationTask notificationTask) {
        Object object = activeTasksLock;
        synchronized (object) {
            activeTasks.add(notificationTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeActiveTask(NotificationTask notificationTask) {
        Object object = activeTasksLock;
        synchronized (object) {
            activeTasks.remove(notificationTask);
            activeTasksLock.notify();
        }
        if (!notificationTask.isCompletedSuccessfully()) {
            this.logger().warning("There were issues processing %s", notificationTask.description);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitActiveTasks(Utils.Deadline deadline) {
        Object object = activeTasksLock;
        synchronized (object) {
            while (!this.hardstop() && !activeTasks.isEmpty()) {
                try {
                    this.logger().debug("Waiting for " + activeTasks + " in progress VM_JAR_LOADED events", new Object[0]);
                    activeTasksLock.wait(Math.max(1L, deadline.remainder(TimeUnit.MILLISECONDS)));
                }
                catch (InterruptedException interruptedException) {
                    Thread.interrupted();
                    break;
                }
            }
            if (!activeTasks.isEmpty()) {
                this.logger().warning("VM_JAR_LOADED_EVENTs processing has timed out. %s still not processed. You may want to increase delayTermination to avoid this.", activeTasks);
            }
        }
    }

    private static URL getJarURL(URL uRL) {
        String string = uRL.toString();
        if (string.contains("!/") && !(string = string.substring(0, string.lastIndexOf("!/"))).contains("!/") && string.startsWith("jar:")) {
            string = string.substring(4);
        }
        if (!(string.endsWith(".jar!/") || string.endsWith(".war!/") || string.endsWith(".jar") || string.endsWith(".war"))) {
            Logger.getLogger(JarLoadMonitor.class).debug("given url=" + uRL + " does not have jar to be reported for load event. source=" + string, new Object[0]);
            return null;
        }
        try {
            return new URL(string);
        }
        catch (Exception exception) {
            Logger.getLogger(JarLoadMonitor.class).warning("Failed to construct jar url from url=%s, modified source string=%s", uRL, string, exception);
            return uRL;
        }
    }

    private ZipTools.JarShortDigest getJarCentralDirectorySignature(URL uRL, JarFile jarFile) throws IOException {
        try {
            URL uRL2 = JarLoadMonitor.getJarURL(uRL);
            if (null == uRL2) {
                return null;
            }
            ZipTools.JarShortDigest jarShortDigest = this.zt.getDigest((MessageDigest)this.md.clone(), uRL2, jarFile);
            if (jarShortDigest == null) {
                return null;
            }
            if (DEBUG) {
                System.out.println(">>> notifyJarLoad url=" + uRL + "\njar=" + jarFile + "\ncentralDirectoryHashString=" + Utils.encodeToStringOrNull(jarShortDigest.getCentralDirectoryHash()) + "\nmanifestHashString=" + Utils.encodeToStringOrNull(jarShortDigest.getManifestHash()));
            }
            if (this.traceOut != null) {
                this.traceOut.println(uRL.toString());
            }
            return jarShortDigest;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    private boolean sendJar(URL uRL, JarFile jarFile) {
        if (!this.jarFileAccess.isAllowed(jarFile.getName())) {
            this.logger().debug("jar=%s file is not allowed to upload. skip", jarFile.getName());
            return true;
        }
        URL uRL2 = JarLoadMonitor.getJarURL(uRL);
        if (uRL2 == null) {
            return false;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("name", jarFile.getName());
        hashMap.put("url", uRL.toString());
        hashMap.put("tags", Inventory.instanceTags());
        return this.syncUpload(jarFile.getName(), VMArtifact.Type.JAR, hashMap, (n, outputStream) -> {
            this.logger().info("sendJar jar=%s url=%s artifactId=%d", jarFile.getName(), uRL, n);
            try (InputStream inputStream = uRL2.openConnection().getInputStream();){
                Utils.transfer(inputStream, outputStream);
            }
        });
    }

    private void visitJarEntries(JarFile jarFile, List<Consumer<JarEntry>> list) {
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (!this.hardstop() && enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            if (jarEntry.isDirectory()) continue;
            list.forEach(consumer -> consumer.accept(jarEntry));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean notifyNestedJars(String string, JarFile jarFile, int n) throws IOException {
        Iterator<JarEntry> iterator = Collections.list(jarFile.entries()).iterator();
        while (iterator.hasNext()) {
            JarEntry jarEntry = iterator.next();
            if (!ZipTools.isJarFile(jarEntry.getName())) continue;
            try {
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                Throwable throwable = null;
                try {
                    Path path = Files.createTempFile("jar_cache", ".jar", new FileAttribute[0]);
                    try {
                        Files.copy(inputStream, path, StandardCopyOption.REPLACE_EXISTING);
                        path.toFile().deleteOnExit();
                        URL uRL = path.toUri().toURL();
                        String string2 = string + jarEntry.getName() + "!/";
                        JarFile jarFile2 = new JarFile(path.toFile());
                        if (this.notifyJarLoad(uRL, jarFile2, InitiatedBy.RECURSIVE_LOADING, string2, n)) continue;
                        boolean bl = false;
                        return bl;
                    }
                    catch (IOException iOException) {
                        try {
                            Files.delete(path);
                            throw iOException;
                        }
                        catch (IOException iOException2) {
                            iOException.addSuppressed(iOException2);
                        }
                        throw iOException;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                this.logger().error("failed to dump nested jar entry %s/%s: %s", jarFile.getName(), jarEntry.getName(), exception);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean notifyJarLoad(URL uRL, JarFile jarFile, InitiatedBy initiatedBy, String string, int n) {
        this.logger().trace("notifyJarLoad %s initiated by %s", new Object[]{uRL, initiatedBy});
        if (this.hardstop()) {
            this.logger().debug("Skip processing notifyJarLoad because of hardstop", new Object[0]);
            return false;
        }
        if (!this.started.get()) {
            this.logger().error("service is not yet started", new Object[0]);
            return false;
        }
        if (uRL == null || jarFile == null) {
            this.logger().debug("Skip processing invalid notifyJarLoad", new Object[0]);
            return false;
        }
        string = URLHelper.toNormalizedJarURL(string);
        boolean bl = false;
        NotificationTask notificationTask = new NotificationTask(jarFile.getName());
        this.addActiveTask(notificationTask);
        try {
            if (uRL.toString().startsWith("file:") || uRL.toString().startsWith("jar:file:")) {
                boolean bl2 = false;
                int n2 = 2;
                try {
                    while (!bl && n2-- > 0) {
                        try {
                            bl = this.notifyJarLoadImpl(uRL, jarFile, initiatedBy, string, n);
                        }
                        catch (ZipTools.ZipFileClosedException zipFileClosedException) {
                            jarFile = new JarFile(uRL.getPath(), false);
                            bl2 = true;
                            this.logger().debug("Reopening %s because jar file has been closed", uRL);
                        }
                    }
                }
                finally {
                    if (bl2) {
                        jarFile.close();
                    }
                }
            } else {
                bl = this.notifyJarLoadImpl(uRL, jarFile, initiatedBy, string, n);
            }
            notificationTask.setCompletionStatus(bl);
        }
        catch (IOException iOException) {
            this.logger().warning("Exception while processing notifyJarLoad (%s)", uRL, iOException);
        }
        finally {
            this.removeActiveTask(notificationTask);
        }
        return notificationTask.isCompletedSuccessfully();
    }

    private boolean notifyJarLoadImpl(URL uRL, JarFile jarFile, InitiatedBy initiatedBy, String string, int n) throws IOException {
        if (knownVmJars.contains(URLHelper.extractContainerPathFromURL(string))) {
            this.logger().trace("Skip VM JAR reporting: %s", string);
            return true;
        }
        if (this.isAlreadyProcessed(string)) {
            this.logger().trace("Skip already processed: %s", string);
            return true;
        }
        boolean bl = !this.hardstop() & this.postVMJarLoadedEvent(uRL, jarFile, string, initiatedBy, n, forceFullJarLoadedEvents);
        if (recursiveJarDiscovery) {
            bl &= !this.hardstop() & this.notifyNestedJars(string, jarFile, n + 1);
        }
        return bl;
    }

    private boolean sendEntries(URL uRL, JarFile jarFile) {
        return jarFile.stream().filter(jarEntry -> this.jarEntryAccess.isAllowed(jarEntry.getName())).map(jarEntry -> this.uploadJarEntry(uRL, jarFile, jarEntry.getName())).allMatch(Boolean.TRUE::equals);
    }

    private boolean postVMJarLoadedEvent(URL uRL, JarFile jarFile, String string, InitiatedBy initiatedBy, int n2, boolean bl) throws IOException {
        boolean bl2;
        Object object;
        AtomicLong atomicLong;
        AtomicLong atomicLong2;
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        ZipTools.JarShortDigest jarShortDigest = sendCentralDirectoryHash ? this.getJarCentralDirectorySignature(uRL, jarFile) : null;
        this.logger().debug("postVMJarLoadedEvent %s initiated by %s (with details: %b)", new Object[]{string, initiatedBy, bl});
        ArrayList<Consumer<JarEntry>> arrayList = new ArrayList<Consumer<JarEntry>>();
        DataEntriesMap<Hashes> dataEntriesMap = new DataEntriesMap<Hashes>(Hashes.class);
        HashSet<MavenComponent> hashSet = new HashSet<MavenComponent>();
        if (bl) {
            atomicLong2 = new AtomicLong();
            if (sendJarEntriesHashes) {
                arrayList.add(jarEntry -> {
                    atomicLong2.addAndGet(-System.nanoTime());
                    try {
                        DataEntriesMap.DataEntry dataEntry = dataEntriesMap.getEntry(jarEntry.getName());
                        dataEntry.put(Hashes.ENTRY_CRC32, String.format("%08x", jarEntry.getCrc()));
                        dataEntry.put(Hashes.ENTRY_SIZE, Long.toString(jarEntry.getSize()));
                    }
                    finally {
                        atomicLong2.addAndGet(System.nanoTime());
                    }
                });
            }
            atomicLong = new AtomicLong();
            if (sendJarEntriesShadedHashes) {
                arrayList.add(jarEntry -> {
                    block17: {
                        atomicLong.addAndGet(-System.nanoTime());
                        try {
                            String string = jarEntry.getName();
                            if (!string.endsWith(".class")) break block17;
                            try {
                                Digest digest = Digest.get();
                                Digest digest2 = Digest.get();
                                try (InputStream inputStream = jarFile.getInputStream((ZipEntry)jarEntry);){
                                    InputStream inputStream2 = new BufferedInputStream(inputStream);
                                    inputStream2 = JarLoadMonitor.wrapStream(inputStream2, digest);
                                    ShadedClassHashCalculator.updateHash(inputStream2, digest2);
                                    dataEntriesMap.put(string, Hashes.CLASS_SHADED_HASH, digest2.asHexString());
                                    inputStream2.skip(Long.MAX_VALUE);
                                    dataEntriesMap.put(string, Hashes.SHA256, digest.asHexString());
                                }
                            }
                            catch (IOException | IllegalAccessException exception) {
                                this.logger().error("Exception: %s", exception);
                            }
                        }
                        finally {
                            atomicLong.addAndGet(System.nanoTime());
                        }
                    }
                });
            }
            object = new AtomicLong();
            arrayList.add(arg_0 -> this.lambda$postVMJarLoadedEvent$7((AtomicLong)object, jarFile, hashSet, arg_0));
            long l = System.nanoTime();
            this.visitJarEntries(jarFile, arrayList);
            hashMap.put("visitJarEntries", System.nanoTime() - l);
            hashMap.put("pomProperties", ((AtomicLong)object).get());
            hashMap.put("jarEntriesShaded", atomicLong.get());
            hashMap.put("jarEntriesHashes", atomicLong2.get());
        }
        if (jarShortDigest == null && dataEntriesMap.isEmpty()) {
            return true;
        }
        atomicLong2 = jarShortDigest == null ? null : Utils.encodeToStringOrNull(jarShortDigest.getCentralDirectoryHash());
        atomicLong = jarShortDigest == null ? null : Utils.encodeToStringOrNull(jarShortDigest.getManifestHash());
        object = jarShortDigest == null ? null : jarShortDigest.getProvider();
        Long l = jarShortDigest == null ? null : Long.valueOf(jarShortDigest.getCentralDirectoryLength());
        long l2 = Utils.currentTimeMillis();
        VMEvent<Map> vMEvent = this.jarLoadEvent(string, initiatedBy, n2, jarFile.getName(), l2, (String)((Object)atomicLong2), (String)((Object)atomicLong), (String)object, l, dataEntriesMap.pack().toExternalForm(), hashSet, hashMap);
        int n3 = vMEvent.toJson().length();
        boolean bl3 = bl2 = n3 > 524288;
        if (this.hardstop()) {
            return false;
        }
        if (!bl) {
            this.addRequestCookie(vMEvent);
        }
        if (!bl2) {
            this.postVMJarLoadedEvent(vMEvent, string);
            return true;
        }
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        hashMap2.put("eventId", vMEvent.getEventId());
        hashMap2.put("tags", Inventory.instanceTags());
        return this.syncUpload("VM_JAR_LOADED event" + vMEvent.getEventId(), VMArtifact.Type.LARGE_VM_EVENT, hashMap2, (n, outputStream) -> {
            PrintStream printStream = new PrintStream((OutputStream)outputStream);
            Utils.serializer.serialize(printStream, (Object)vMEvent);
            Map map = (Map)vMEvent.getEventPayload();
            map.remove("entries");
            map.put("STORED_VM_JAR_LOADED_EVENT", Client.artifactIdToString(n));
            this.postVMJarLoadedEvent(vMEvent, string);
        });
    }

    private void postVMJarLoadedEvent(VMEvent vMEvent, String string) {
        this.client.postVMEvent(vMEvent);
        this.setAlreadyProcessed(string);
    }

    private VMEvent addRequestCookie(VMEvent vMEvent) {
        String string;
        Map map = (Map)vMEvent.getEventPayload();
        Object v = map.get("url");
        Object v2 = map.get("jarName");
        if (v != null && v2 != null && (string = ServerRequest.VmJarInfoRequestCookie.encode(v2.toString(), v.toString())) != null) {
            map.put("requestCookie", string);
        }
        return vMEvent;
    }

    private static InputStream wrapStream(InputStream inputStream, Digest digest) {
        return new DigestInputStream(inputStream, digest.getMessageDigest()){

            @Override
            public long skip(long l) throws IOException {
                int n;
                long l2;
                if (l <= 0L) {
                    return 0L;
                }
                int n2 = (int)Math.min(2048L, l2);
                byte[] byArray = new byte[n2];
                for (l2 = l; l2 > 0L && (n = this.read(byArray, 0, (int)Math.min((long)n2, l2))) >= 0; l2 -= (long)n) {
                }
                return l - l2;
            }

            @Override
            public boolean markSupported() {
                return false;
            }
        };
    }

    public void notifyJarLoad(URL uRL, JarFile jarFile) {
        InitiatedBy initiatedBy = ZipTools.isJDKNative(jarFile) ? InitiatedBy.JDK_NATIVE_LOADING : InitiatedBy.OTHER;
        this.notifyJarLoad(uRL, jarFile, initiatedBy, uRL.toString(), 0);
    }

    private boolean uploadJarEntry(URL uRL, JarFile jarFile, String string) {
        if (!this.jarEntryAccess.isAllowed(string)) {
            this.logger().error("it is not allowed to send jar=%s entry=%s url=%s list=%s", jarFile.getName(), string, uRL, sendJarEntriesList);
            return true;
        }
        JarEntry jarEntry = jarFile.getJarEntry(string);
        if (jarEntry == null) {
            this.logger().info("jar entry=%s is not present in jar=%s url=%s", string, jarFile.getName(), uRL);
            return true;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("jar", jarFile.getName());
        hashMap.put("url", uRL.toString());
        hashMap.put("entry", string);
        hashMap.put("tags", Inventory.instanceTags());
        return this.syncUpload(jarFile.getName() + "!" + jarEntry.getName(), VMArtifact.Type.JAR_ENTRY, hashMap, (n, outputStream) -> {
            this.logger().info("uploadJarEntry: jar=%s entry=%s url=%s artifactId=%d", jarFile.getName(), string, uRL, n);
            try (InputStream inputStream = jarFile.getInputStream(jarEntry);){
                Utils.transfer(inputStream, outputStream);
            }
        });
    }

    private boolean syncUpload(String string, VMArtifact.Type type, Map<String, Object> map, ThrowingBiConsumer<Integer, OutputStream, IOException> throwingBiConsumer) {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        int n = this.client.createArtifactId();
        this.client.postVMArtifact(type, n, map, outputStream -> {
            try {
                throwingBiConsumer.accept(n, outputStream);
                atomicBoolean.set(true);
            }
            catch (IOException iOException) {
                this.logger().error("syncUpload for %s failed: %s", string, iOException);
            }
            finally {
                countDownLatch.countDown();
            }
        });
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            this.logger().warning("syncUpload for %s interrupted", string);
        }
        return atomicBoolean.get();
    }

    public void notifyClassSourceSeen(String string) {
        block11: {
            try {
                if (string == null) {
                    return;
                }
                if (!jarLoadByClassLoad) {
                    return;
                }
                if ("__JVM_DefineClass__".equals(string)) {
                    return;
                }
                try {
                    if (string.matches("^file:.*\\.jar$")) {
                        string = "jar:" + string + "!/";
                    }
                    if (!string.endsWith(".jar!/")) {
                        return;
                    }
                    URL uRL = new URL(string);
                    String string2 = uRL.toString();
                    if (this.isAlreadyProcessed(string2)) {
                        this.logger().trace("Skip already processed: %s", string2);
                        return;
                    }
                    URLConnection uRLConnection = uRL.openConnection();
                    if (uRLConnection instanceof JarURLConnection) {
                        JarURLConnection jarURLConnection = (JarURLConnection)uRLConnection;
                        JarFile jarFile = jarURLConnection.getJarFile();
                        this.notifyJarLoad(uRL, jarFile, InitiatedBy.CLASS_LOADING, string2, 0);
                        break block11;
                    }
                    this.logger().debug("Cannot open JarURLConnection from given class source (%s) (URLConnection.class=%s)", string, uRLConnection.getClass().getName());
                }
                catch (Exception exception) {
                    this.logger().debug("Class source (%s) is malformed or is not applicable to extract jar file", string, exception);
                }
            }
            catch (Exception exception) {
                System.out.println("!!! unexpected exception: " + exception);
                exception.printStackTrace();
            }
        }
    }

    private static boolean getBooleanProperty(String string, boolean bl) {
        return Boolean.parseBoolean(System.getProperty(string, String.valueOf(bl)));
    }

    private static int getIntProperty(String string, int n) {
        return Integer.parseInt(System.getProperty(string, String.valueOf(n)));
    }

    private static Set<String> initKnownVmJars() {
        String string = System.getProperty("java.home");
        String string2 = System.getProperty("java.specification.version");
        return KnownAzulRuntimeContainers.get(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$postVMJarLoadedEvent$7(AtomicLong atomicLong, JarFile jarFile, Set set, JarEntry jarEntry) {
        block17: {
            atomicLong.addAndGet(-System.nanoTime());
            try {
                if (!jarEntry.getName().endsWith("/pom.properties")) break block17;
                try (InputStream inputStream = jarFile.getInputStream(jarEntry);){
                    MavenComponent mavenComponent = new MavenComponent();
                    mavenComponent.load(inputStream);
                    set.add(mavenComponent);
                }
                catch (IOException iOException) {
                    this.logger().warning("Failed to read %s: %s", jarEntry.getName(), iOException.toString());
                }
            }
            finally {
                atomicLong.addAndGet(System.nanoTime());
            }
        }
    }

    private static class NotificationTask {
        private final AtomicBoolean completedSuccessfully = new AtomicBoolean();
        private final String description;

        private NotificationTask(String string) {
            this.description = string;
        }

        private void setCompletionStatus(boolean bl) {
            this.completedSuccessfully.set(bl);
        }

        private boolean isCompletedSuccessfully() {
            return this.completedSuccessfully.get();
        }

        public String toString() {
            return this.description;
        }
    }

    private static final class MavenComponent
    extends Properties {
        private MavenComponent() {
        }
    }

    @FunctionalInterface
    public static interface ThrowingBiConsumer<T, U, E extends Throwable> {
        public void accept(T var1, U var2) throws E;
    }

    private static enum Hashes {
        ENTRY_CRC32,
        ENTRY_SIZE,
        SHA256,
        CLASS_SHADED_HASH;

    }

    public static enum InitiatedBy {
        CLASS_LOADING,
        JDK_NATIVE_LOADING,
        RECURSIVE_LOADING,
        SERVER_REQUEST,
        OTHER;

    }

    private static final class JarFileAccess {
        private final Collection<Pattern> patterns = new ArrayList<Pattern>();

        JarFileAccess(String string) {
            if (string != null && string.length() > 0) {
                for (String string2 : string.split(",")) {
                    string2 = string2.replaceAll("\\*\\*", "%%%%1%%%%");
                    string2 = string2.replaceAll("\\*", "%%%%2%%%%");
                    string2 = string2.replaceAll("%%%%1%%%%", ".*");
                    string2 = string2.replaceAll("%%%%2%%%%", "[^/]*");
                    this.patterns.add(Pattern.compile(string2));
                }
            }
        }

        public boolean isAllowed(String string) {
            for (Pattern pattern : this.patterns) {
                if (!pattern.matcher(string).matches()) continue;
                return true;
            }
            return false;
        }
    }

    private static final class JarEntryAccess {
        private static final String prefix = "**/";
        private final Collection<String> entireFileNameMatch = new ArrayList<String>();
        private final Collection<String> suffixMatch = new ArrayList<String>();

        JarEntryAccess(String string) {
            for (String string2 : string.split(",")) {
                if (string2.startsWith(prefix)) {
                    this.suffixMatch.add(string2.substring(prefix.length()));
                    continue;
                }
                this.entireFileNameMatch.add(string2);
            }
        }

        public boolean isAllowed(String string) {
            if (string == null) {
                return false;
            }
            if (this.entireFileNameMatch.contains(string)) {
                return true;
            }
            for (String string2 : this.suffixMatch) {
                int n;
                int n2 = string.length();
                if (n2 < (n = string2.length()) || !string.endsWith(string2) || n2 != n && string.charAt(n2 - n - 1) != '/') continue;
                return true;
            }
            return false;
        }
    }
}

