/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.service;

import com.azul.crs.client.Client;
import com.azul.crs.client.Utils;
import com.azul.crs.client.models.VMEvent;
import com.azul.crs.client.service.ClientService;
import com.azul.crs.util.logging.Logger;
import java.util.HashMap;

public class FirstCallMonitor
implements ClientService {
    private static final FirstCallMonitor instance = new FirstCallMonitor();
    private Client client;
    private volatile boolean started;
    private volatile boolean stopped;

    private FirstCallMonitor() {
    }

    public static FirstCallMonitor getInstance(Client client) {
        FirstCallMonitor.instance.client = client;
        return instance;
    }

    private static VMEvent methodEntryEvent(int n, String string, long l) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("classId", Integer.toString(n));
        hashMap.put("methodName", string);
        return new VMEvent().eventType(VMEvent.Type.VM_METHOD_FIRST_CALLED).eventTime(l).eventPayload(hashMap);
    }

    @Override
    public synchronized void start() {
        this.started = true;
    }

    @Override
    public synchronized void stop(Utils.Deadline deadline) {
        this.started = false;
        this.stopped = true;
    }

    public void notifyMethodFirstCalled(int n, String string) {
        if (this.stopped) {
            return;
        }
        if (!this.started) {
            this.logger().error("service is not yet started", new Object[0]);
            return;
        }
        Logger.getLogger(FirstCallMonitor.class).trace("Entered " + string, new Object[0]);
        long l = Utils.currentTimeMillis();
        this.client.postVMEvent(FirstCallMonitor.methodEntryEvent(n, string, l));
    }
}

