/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client;

import com.azul.crs.util.logging.Logger;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.HttpsURLConnection;
import sun.net.www.http.HttpClient;
import sun.net.www.protocol.http.HttpURLConnection;
import sun.net.www.protocol.https.HttpsURLConnectionImpl;

public class PerformanceMetrics {
    private final AtomicLong communicationMillis = new AtomicLong();
    private final AtomicLong numBytesOut = new AtomicLong();
    private final AtomicLong numBytesIn = new AtomicLong();
    private long shutdownMillis;
    private final AtomicLong preShutdownMillis = new AtomicLong();
    private final AtomicLong numEvents = new AtomicLong();
    private final AtomicLong numEventBatches = new AtomicLong();
    private final AtomicLong[] numEventHistogram = new AtomicLong[20];
    private final AtomicLong numConnections = new AtomicLong();
    private final AtomicLong numRequests = new AtomicLong();
    private final AtomicLong handshakeMillis = new AtomicLong();
    private final AtomicInteger maxQueueLength = new AtomicInteger();
    private final AtomicLong numBytesInArtifacts = new AtomicLong();
    private final AtomicLong numClassLoads = new AtomicLong();
    private final AtomicLong numJarLoads = new AtomicLong();
    private final AtomicLong numMethodEntries = new AtomicLong();
    private static final Map<String, Number> fieldDesc = new HashMap<String, Number>();
    private static PerformanceMetrics instance;
    private static Field connectionHttpsDelegateField;
    private static Field connectionHttpField;

    static void init() {
        instance = new PerformanceMetrics();
        for (int i = 0; i < PerformanceMetrics.instance.numEventHistogram.length; ++i) {
            PerformanceMetrics.instance.numEventHistogram[i] = new AtomicLong();
        }
        for (Field field : PerformanceMetrics.class.getDeclaredFields()) {
            if (!Number.class.isAssignableFrom(field.getType())) continue;
            try {
                fieldDesc.put(field.getName(), (Number)field.get(instance));
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
        try {
            connectionHttpsDelegateField = HttpsURLConnectionImpl.class.getDeclaredField("delegate");
            connectionHttpsDelegateField.setAccessible(true);
            connectionHttpField = HttpURLConnection.class.getDeclaredField("http");
            connectionHttpField.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void logNetworkTime(long l) {
        PerformanceMetrics.instance.communicationMillis.addAndGet(l);
    }

    static void logHandshakeTime(long l, HttpsURLConnection httpsURLConnection) {
        PerformanceMetrics.instance.handshakeMillis.addAndGet(l);
        PerformanceMetrics.instance.numRequests.incrementAndGet();
        if (connectionHttpsDelegateField != null && connectionHttpField != null) {
            try {
                HttpClient httpClient = (HttpClient)connectionHttpField.get(connectionHttpsDelegateField.get(httpsURLConnection));
                if (!httpClient.isCachedConnection()) {
                    PerformanceMetrics.instance.numConnections.incrementAndGet();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static void logBytes(long l, long l2) {
        PerformanceMetrics.instance.numBytesIn.addAndGet(l);
        PerformanceMetrics.instance.numBytesOut.addAndGet(l2);
    }

    static void logShutdown(long l) {
        PerformanceMetrics.instance.shutdownMillis = l;
    }

    public static void logEventBatch(long l) {
        PerformanceMetrics.instance.numEvents.addAndGet(l);
        PerformanceMetrics.instance.numEventBatches.incrementAndGet();
        PerformanceMetrics.instance.numEventHistogram[(int)(Math.log(l) / Math.log(2.0))].incrementAndGet();
    }

    public static void logClassLoads(long l) {
        PerformanceMetrics.instance.numClassLoads.addAndGet(l);
    }

    public static void logJarLoads(long l) {
        PerformanceMetrics.instance.numJarLoads.addAndGet(l);
    }

    public static void logMethodEntries(long l) {
        PerformanceMetrics.instance.numMethodEntries.addAndGet(l);
    }

    public static void logEventQueueLength(int n) {
        int n2;
        AtomicInteger atomicInteger = PerformanceMetrics.instance.maxQueueLength;
        while ((n2 = atomicInteger.get()) < n && !atomicInteger.compareAndSet(n2, n)) {
        }
    }

    public static Map logPreShutdown(long l) {
        PerformanceMetrics.instance.preShutdownMillis.set(l);
        return instance.toEventPayload();
    }

    public static void logArtifactBytes(long l) {
        PerformanceMetrics.instance.numBytesInArtifacts.addAndGet(l);
    }

    private Map toEventPayload() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<String, Number> entry : fieldDesc.entrySet()) {
            hashMap.put(entry.getKey(), entry.getValue().toString());
        }
        return hashMap;
    }

    static void report() {
        Logger logger = Logger.getLogger(PerformanceMetrics.class);
        if (logger.isEnabled(Logger.Level.INFO)) {
            StringBuilder stringBuilder = new StringBuilder();
            for (AtomicLong atomicLong : PerformanceMetrics.instance.numEventHistogram) {
                stringBuilder.append(atomicLong.get()).append(' ');
            }
            logger.info("total communication duration %.3fs\nnumber of executed requests is %d using %d established connections, %.3fs spent in handshake\ntotal bytes in %.3fM\ntotal event data bytes out %.3fM\ntotal artifacts bytes %.3fM\nmaximum queue length %d\nshutdown delay %.3fs (pre %.3fs)\nclasses loaded %d\njars loaded %d\nmethods invoked %d\nevents sent %d batches %d [%s]\n", (double)PerformanceMetrics.instance.communicationMillis.get() / 1000.0, PerformanceMetrics.instance.numRequests.get(), PerformanceMetrics.instance.numConnections.get(), (double)PerformanceMetrics.instance.handshakeMillis.get() / 1000.0, (double)PerformanceMetrics.instance.numBytesIn.get() / 1024.0 / 1024.0, (double)PerformanceMetrics.instance.numBytesOut.get() / 1024.0 / 1024.0, (double)PerformanceMetrics.instance.numBytesInArtifacts.get() / 1024.0 / 1024.0, PerformanceMetrics.instance.maxQueueLength.get(), (double)PerformanceMetrics.instance.shutdownMillis / 1000.0, (double)PerformanceMetrics.instance.preShutdownMillis.get() / 1000.0, PerformanceMetrics.instance.numClassLoads.get(), PerformanceMetrics.instance.numJarLoads.get(), PerformanceMetrics.instance.numMethodEntries.get(), PerformanceMetrics.instance.numEvents.get(), PerformanceMetrics.instance.numEventBatches.get(), stringBuilder.toString());
        }
    }
}

